/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppLevelTIMLoader
extends URLClassLoader {
    private final ClassLoader appLoader;
    private volatile ClassFileTransformer transformer;

    public AppLevelTIMLoader(URL[] urls, ClassLoader parent, ClassLoader appLoader) {
        super(urls, parent);
        this.appLoader = appLoader;
    }

    void setTransformer(ClassFileTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> rv = this.findLoadedClass(name);
        if (rv != null) {
            return rv;
        }
        try {
            return this.getParent().loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            String resName = name.replace('.', '/').concat(".class");
            URL resource = this.getResource(resName);
            if (resource != null) {
                byte[] clazzBytes;
                try {
                    clazzBytes = this.readResource(resource);
                }
                catch (IOException ioe) {
                    throw new ClassNotFoundException(name, ioe);
                }
                try {
                    clazzBytes = this.transformer.transform(this, name, null, null, clazzBytes);
                }
                catch (IllegalClassFormatException e) {
                    throw new AssertionError((Object)e);
                }
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
            return this.appLoader.loadClass(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readResource(URL resource) throws IOException {
        InputStream in = null;
        try {
            int read;
            in = resource.openStream();
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((read = in.read(buf)) > 0) {
                baos.write(buf, 0, read);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

