/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.openjpa.datacache;

import java.util.Map;
import net.sf.ehcache.openjpa.datacache.EhCacheDataCache;
import net.sf.ehcache.openjpa.datacache.EhCacheDataCacheManager;
import net.sf.ehcache.openjpa.datacache.EhCacheQueryCache;
import net.sf.ehcache.openjpa.datacache.NoOpRemoteCommitProvider;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.Localizer;

public class EhCacheDerivation
extends AbstractProductDerivation {
    public static final String EHCACHE = "ehcache";
    public static final String NO_RCP = "none";
    private static final Localizer LOCALIZER = Localizer.forPackage(EhCacheDerivation.class);

    public void validate() throws Exception {
        Class.forName("net.sf.ehcache.CacheManager");
    }

    public int getType() {
        return 1000;
    }

    public boolean beforeConfigurationLoad(Configuration conf) {
        if (conf instanceof OpenJPAConfiguration) {
            OpenJPAConfigurationImpl oconf = (OpenJPAConfigurationImpl)conf;
            oconf.dataCacheManagerPlugin.setAlias(EHCACHE, EhCacheDataCacheManager.class.getName());
            oconf.dataCachePlugin.setAlias(EHCACHE, EhCacheDataCache.class.getName());
            oconf.queryCachePlugin.setAlias(EHCACHE, EhCacheQueryCache.class.getName());
            oconf.remoteProviderPlugin.setAlias(NO_RCP, NoOpRemoteCommitProvider.class.getName());
        }
        return false;
    }

    public boolean beforeConfigurationConstruct(ConfigurationProvider cp) {
        Map props = cp.getProperties();
        Object dcm = Configurations.getProperty((String)"DataCacheManager", (Map)props);
        if (dcm != null && this.isCompliant(dcm, EhCacheDataCacheManager.class)) {
            Object dc = Configurations.getProperty((String)"DataCache", (Map)props);
            if (dc == null) {
                cp.addProperty("openjpa.DataCache", (Object)EHCACHE);
            } else if (!this.isCompliant(dc, EhCacheDataCache.class)) {
                this.warn("incompatible-configuration", "DataCache", dc, EHCACHE);
                cp.addProperty("openjpa.DataCache", (Object)EHCACHE);
            }
            Object rcp = Configurations.getProperty((String)"RemoteCommitProvider", (Map)props);
            if (rcp == null) {
                cp.addProperty("openjpa.RemoteCommitProvider", (Object)NoOpRemoteCommitProvider.class.getName());
            } else if (!this.isCompliant(rcp, NoOpRemoteCommitProvider.class)) {
                this.warn("incompatible-configuration", "RemoteCommitProvider", rcp, NO_RCP);
                cp.addProperty("openjpa.RemoteCommitProvider", (Object)NO_RCP);
            }
            Object qc = Configurations.getProperty((String)"QueryCache", (Map)props);
            if (qc == null) {
                cp.addProperty("openjpa.QueryCache", (Object)EHCACHE);
            }
        }
        return false;
    }

    boolean isCompliant(Object dcm, Class cls) {
        return dcm.equals(EHCACHE) || dcm.equals(cls.getName()) || cls.isAssignableFrom(dcm.getClass());
    }

    void warn(String key, Object ... args) {
        Localizer.Message message = LOCALIZER.get(key, args);
        System.err.println("*** WARN: " + message);
    }
}

