/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.PersistenceConfiguration;

public final class ConfigurationRules {
    private ConfigurationRules() {
    }

    public static void validateConfig(CacheConfiguration existing, CacheConfiguration config) {
        ConfigurationRules.validatePersistenceConfiguration(existing, config);
        ConfigurationRules.validateTierConfiguration(existing, config);
        ConfigurationRules.validateWriteBehindConfiguration(existing, config);
        ConfigurationRules.validateTransactionsConfiguration(existing, config);
    }

    private static void validatePersistenceConfiguration(CacheConfiguration existing, CacheConfiguration config) {
        if (!PersistenceConfiguration.Strategy.LOCALRESTARTABLE.equals((Object)existing.getPersistenceConfiguration().getStrategy())) {
            throw new AssertionError((Object)"Non-restartable cache in metadata cache set!");
        }
        if (config.getPersistenceConfiguration() == null || !PersistenceConfiguration.Strategy.LOCALRESTARTABLE.equals((Object)config.getPersistenceConfiguration().getStrategy())) {
            throw new InvalidConfigurationException("Cannot recover previously created restartable cache '" + config.getName() + "' to a non-restartable cache.");
        }
    }

    private static void validateTierConfiguration(CacheConfiguration existing, CacheConfiguration config) {
        if (existing.isOverflowToDisk()) {
            if (!config.isOverflowToDisk()) {
                throw new InvalidConfigurationException("Cannot recover previously created disk cache '" + config.getName() + "' to a non-disk cache.");
            }
        } else if (existing.isOverflowToOffHeap()) {
            if (config.isOverflowToDisk()) {
                throw new InvalidConfigurationException("Cannot recover previously created offheap cache '" + config.getName() + "' to a disk cache.");
            }
            if (!config.isOverflowToOffHeap()) {
                throw new InvalidConfigurationException("Cannot recover previously created offheap cache '" + config.getName() + "' to a heap cache.");
            }
        } else {
            if (config.isOverflowToDisk()) {
                throw new InvalidConfigurationException("Cannot recover previously created heap cache '" + config.getName() + "' to a disk cache.");
            }
            if (config.isOverflowToOffHeap()) {
                throw new InvalidConfigurationException("Cannot recover previously created heap cache '" + config.getName() + "' to an offheap cache.");
            }
        }
    }

    private static void validateWriteBehindConfiguration(CacheConfiguration existing, CacheConfiguration config) {
        CacheWriterConfiguration existingWriter = existing.getCacheWriterConfiguration();
        CacheWriterConfiguration configWriter = config.getCacheWriterConfiguration();
        if (!existingWriter.getWriteMode().equals((Object)configWriter.getWriteMode())) {
            throw new InvalidConfigurationException("Cannot recover previously created cache '" + config.getName() + "' with write mode " + (Object)((Object)existingWriter.getWriteMode()) + " to a cache with write mode " + (Object)((Object)configWriter.getWriteMode()));
        }
        if (CacheWriterConfiguration.WriteMode.WRITE_BEHIND.equals((Object)existingWriter.getWriteMode()) && existingWriter.getWriteBehindConcurrency() != configWriter.getWriteBehindConcurrency()) {
            throw new InvalidConfigurationException("Cannot recover previously created cache '" + config.getName() + "' with write behind concurrency " + existingWriter.getWriteBehindConcurrency() + " to a cache with write behind concurrency " + configWriter.getWriteBehindConcurrency());
        }
    }

    private static void validateTransactionsConfiguration(CacheConfiguration existing, CacheConfiguration config) {
        if (!existing.getTransactionalMode().equals((Object)config.getTransactionalMode())) {
            throw new InvalidConfigurationException("Cannot recover previously created cache '" + config.getName() + "' with transactional mode " + (Object)((Object)existing.getTransactionalMode()) + " to a cache with transactional mode " + (Object)((Object)config.getTransactionalMode()));
        }
    }
}

