/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.StandardMBean;

public class CompoundingBean
implements DynamicMBean {
    private final Map<String, DynamicMBean> beans = new HashMap<String, DynamicMBean>();

    public CompoundingBean(Map<String, Object> beans) throws NotCompliantMBeanException {
        for (Map.Entry<String, Object> e : beans.entrySet()) {
            if (e.getValue() instanceof DynamicMBean) {
                this.beans.put(e.getKey(), (DynamicMBean)e.getValue());
                continue;
            }
            this.beans.put(e.getKey(), new StandardMBean(e.getValue(), null));
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.beans.get(this.getPrefix(attribute)).getAttribute(this.getName(attribute));
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.beans.get(this.getPrefix(attribute.getName())).setAttribute(new Attribute(this.getName(attribute.getName()), attribute.getValue()));
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList results = new AttributeList(attributes.length);
        for (String a : attributes) {
            try {
                results.add(new Attribute(a, this.beans.get(this.getPrefix(a)).getAttribute(this.getName(a))));
            }
            catch (JMException ex) {
                // empty catch block
            }
        }
        return results;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        for (Object o : attributes) {
            Attribute a = (Attribute)o;
            try {
                this.beans.get(this.getPrefix(a.getName())).setAttribute(new Attribute(this.getName(a.getName()), a.getValue()));
                results.add(a);
            }
            catch (JMException ex) {}
        }
        return results;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            return this.beans.get(this.getPrefix(actionName)).invoke(this.getName(actionName), params, signature);
        }
        catch (AttributeNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    private String getPrefix(String name) throws AttributeNotFoundException {
        String[] elements = name.split(":", 2);
        if (elements.length != 2) {
            throw new AttributeNotFoundException("Invalid compound attribute name");
        }
        return elements[0];
    }

    private String getName(String name) throws AttributeNotFoundException {
        String[] elements = name.split(":", 2);
        if (elements.length != 2) {
            throw new AttributeNotFoundException("Invalid compound attribute name");
        }
        return elements[1];
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanConstructorInfo> constructors = new ArrayList<MBeanConstructorInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        ArrayList<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
        StringBuilder compoundName = new StringBuilder();
        for (Map.Entry<String, DynamicMBean> e : this.beans.entrySet()) {
            String prefix = e.getKey() + ":";
            MBeanInfo info = e.getValue().getMBeanInfo();
            compoundName.append(':').append(info.getClassName());
            for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
                attributes.add(new MBeanAttributeInfo(prefix + mBeanAttributeInfo.getName(), mBeanAttributeInfo.getType(), mBeanAttributeInfo.getDescription(), mBeanAttributeInfo.isReadable(), mBeanAttributeInfo.isWritable(), mBeanAttributeInfo.isIs()));
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : info.getConstructors()) {
                constructors.add(new MBeanConstructorInfo(prefix + mBeanFeatureInfo.getName(), mBeanFeatureInfo.getDescription(), ((MBeanConstructorInfo)mBeanFeatureInfo).getSignature()));
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
                operations.add(new MBeanOperationInfo(prefix + mBeanFeatureInfo.getName(), mBeanFeatureInfo.getDescription(), ((MBeanOperationInfo)mBeanFeatureInfo).getSignature(), ((MBeanOperationInfo)mBeanFeatureInfo).getReturnType(), ((MBeanOperationInfo)mBeanFeatureInfo).getImpact()));
            }
            for (MBeanFeatureInfo mBeanFeatureInfo : info.getNotifications()) {
                notifications.add(new MBeanNotificationInfo(((MBeanNotificationInfo)mBeanFeatureInfo).getNotifTypes(), prefix + mBeanFeatureInfo.getName(), mBeanFeatureInfo.getDescription()));
            }
        }
        return new MBeanInfo(CompoundingBean.class.getName(), "Compound Bean Of " + compoundName, attributes.toArray(new MBeanAttributeInfo[0]), constructors.toArray(new MBeanConstructorInfo[0]), operations.toArray(new MBeanOperationInfo[0]), notifications.toArray(new MBeanNotificationInfo[0]));
    }
}

