/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.persistent;

import com.terracottatech.offheapstore.AbstractOffHeapClockCache;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.Persistent;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.util.FindbugsSuppressWarnings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.MappedByteBuffer;
import java.util.concurrent.locks.Lock;

public abstract class AbstractPersistentOffHeapCache<K, V>
extends AbstractOffHeapClockCache<K, V>
implements Persistent {
    private static final int MAGIC = 0x494C4C49;

    public AbstractPersistentOffHeapCache(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, bootstrap);
    }

    public AbstractPersistentOffHeapCache(MappedPageSource tableSource, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super((PageSource)tableSource, storageEngine, tableSize, bootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            ((MappedByteBuffer)this.hashTablePage.asByteBuffer()).force();
            ((Persistent)((Object)this.storageEngine)).flush();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            ((MappedPageSource)this.tableSource).close();
            ((Persistent)((Object)this.storageEngine)).close();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist(ObjectOutput output) throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            output.writeInt(0x494C4C49);
            output.writeLong(((MappedPageSource)this.tableSource).getAddress(this.hashTablePage));
            output.writeInt(this.hashTablePage.size());
            output.writeInt(this.reprobeLimit);
            ((Persistent)((Object)this.storageEngine)).persist(output);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FindbugsSuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void bootstrap(ObjectInput input) throws IOException {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (this.hashtable != null) {
                throw new IllegalStateException();
            }
            if (input.readInt() != 0x494C4C49) {
                throw new IOException("Wrong magic number");
            }
            long tableAddress = input.readLong();
            long tableCapacity = input.readInt();
            this.hashTablePage = ((MappedPageSource)this.tableSource).claimPage(tableAddress, tableCapacity);
            this.hashtable = this.hashTablePage.asIntBuffer();
            this.reprobeLimit = input.readInt();
            int[] entry = new int[4];
            this.hashtable.clear();
            while (this.hashtable.hasRemaining()) {
                this.hashtable.get(entry);
                if (AbstractPersistentOffHeapCache.isPresent(entry)) {
                    int slot = this.hashtable.position() - 4;
                    ++this.size;
                    this.added(slot);
                    continue;
                }
                if (!AbstractPersistentOffHeapCache.isRemoved(entry)) continue;
                ++this.removedSlots;
            }
            ((Persistent)((Object)this.storageEngine)).bootstrap(input);
        }
        finally {
            l.unlock();
        }
    }
}

