/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object.heap;

import com.terracottatech.frs.object.AbstractObjectManager;
import com.terracottatech.frs.object.AbstractObjectManagerStripe;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.frs.object.ValueSortedMap;
import com.terracottatech.frs.object.heap.HeapValueSortedMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HeapObjectManager<I, K, V>
extends AbstractObjectManager<I, K, V> {
    private final ConcurrentMap<I, ObjectManagerStripe<I, K, V>> maps = new ConcurrentHashMap<I, ObjectManagerStripe<I, K, V>>();
    private final int concurrency;

    public HeapObjectManager(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    protected ObjectManagerStripe<I, K, V> getStripeFor(I id) {
        ObjectManagerStripe<I, K, V> racer;
        ObjectManagerStripe<I, K, V> stripe = (ObjectManagerStripe<I, K, V>)this.maps.get(id);
        if (stripe == null && (racer = this.maps.putIfAbsent(id, stripe = this.createStripes(id))) != null) {
            stripe = racer;
        }
        return stripe;
    }

    @Override
    public void delete(I id) {
        this.maps.remove(id);
    }

    @Override
    protected Collection<ObjectManagerStripe<I, K, V>> getStripes() {
        return this.maps.values();
    }

    private ObjectManagerStripe<I, K, V> createStripes(I identifier) {
        return new InHeapObjectManagerStripe(identifier, this.concurrency);
    }

    static class InHeapObjectManagerSegment<I, K, V>
    implements ObjectManagerSegment<I, K, V> {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final I identifier;
        private final Map<K, V> dataMap = new HashMap();
        private final ValueSortedMap<K, Long> lsnMap = new HeapValueSortedMap<K, Long>();
        private ObjectManagerEntry<I, K, V> compactingEntry;

        public InHeapObjectManagerSegment(I identifier) {
            this.identifier = identifier;
        }

        @Override
        public ObjectManagerEntry<I, K, V> acquireCompactionEntry(long ceilingLsn) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                assert (this.compactingEntry == null);
                K firstKey = this.lsnMap.firstKey();
                if (firstKey != null) {
                    if (this.lsnMap.firstValue() >= ceilingLsn) {
                        l.unlock();
                        return null;
                    }
                    long lsn = this.lsnMap.get(firstKey);
                    V value = this.dataMap.get(firstKey);
                    this.compactingEntry = new SimpleObjectManagerEntry<I, K, V>(this.identifier, firstKey, value, lsn);
                    return this.compactingEntry;
                }
            }
            catch (Exception e) {
                l.unlock();
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public void releaseCompactionEntry(ObjectManagerEntry<I, K, V> entry) {
            assert (entry == this.compactingEntry);
            this.compactingEntry = null;
            this.lock.writeLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateLsn(int hash, ObjectManagerEntry<I, K, V> entry, long newLsn) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                if (this.lsnMap.get(entry.getKey()).longValue() == entry.getLsn()) {
                    this.lsnMap.put(entry.getKey(), newLsn);
                }
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLowestLsn() {
            Lock l = this.lock.readLock();
            l.lock();
            try {
                Long firstLsn = this.lsnMap.firstValue();
                if (firstLsn == null) {
                    assert (this.dataMap.size() == this.lsnMap.size());
                    Long l2 = null;
                    return l2;
                }
                assert (this.dataMap.size() == this.lsnMap.size());
                Long l3 = firstLsn;
                return l3;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLsn(int hash, K key) {
            Lock l = this.lock.readLock();
            l.lock();
            try {
                Long l2 = this.lsnMap.get(key);
                return l2;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public void replayPut(int hash, K key, V value, long lsn) {
            this.put(hash, key, value, lsn);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(int hash, K key, V value, long lsn) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                this.dataMap.put(key, value);
                this.lsnMap.put(key, lsn);
                assert (this.dataMap.size() == this.lsnMap.size());
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(int hash, K key) {
            Lock l = this.lock.writeLock();
            l.lock();
            try {
                this.dataMap.remove(key);
                this.lsnMap.remove(key);
                assert (this.dataMap.size() == this.lsnMap.size());
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public long size() {
            assert (this.dataMap.size() == this.lsnMap.size());
            return this.dataMap.size();
        }

        @Override
        public long sizeInBytes() {
            throw new UnsupportedOperationException("Size in bytes not supported.");
        }
    }

    static class InHeapObjectManagerStripe<I, K, V>
    extends AbstractObjectManagerStripe<I, K, V> {
        private final ObjectManagerSegment<I, K, V>[] segments;

        public InHeapObjectManagerStripe(I identifier, int stripes) {
            this.segments = new ObjectManagerSegment[stripes];
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new InHeapObjectManagerSegment(identifier);
            }
        }

        @Override
        public Collection<ObjectManagerSegment<I, K, V>> getSegments() {
            return Arrays.asList(this.segments);
        }

        @Override
        protected ObjectManagerSegment<I, K, V> getSegmentFor(int hash, K key) {
            return this.segments[Math.abs(hash % this.segments.length)];
        }

        @Override
        protected int extractHashCode(K key) {
            return key.hashCode();
        }

        @Override
        public long size() {
            long size = 0L;
            for (ObjectManagerSegment<I, K, V> segment : this.getSegments()) {
                size += segment.size();
            }
            return size;
        }

        @Override
        public void delete() {
        }
    }
}

