/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.TreeMap;

public class CachingBufferSource
implements BufferSource {
    private long totalSize;
    private final TreeMap<Integer, ByteBuffer> freeList = new TreeMap(new Comparator<Integer>(){

        @Override
        public int compare(Integer t, Integer t1) {
            return t - t1;
        }
    });

    @Override
    public ByteBuffer getBuffer(int size) {
        if (this.freeList.isEmpty()) {
            return null;
        }
        Integer get = this.freeList.ceilingKey(size);
        if (get == null) {
            get = this.freeList.floorKey(size);
        }
        ByteBuffer buffer = this.freeList.remove(get);
        this.totalSize -= (long)buffer.capacity();
        if (buffer.capacity() < size) {
            this.findSlot(buffer);
            return null;
        }
        assert (this.frameIsZeroed(buffer));
        buffer.clear();
        buffer.limit(size);
        if (buffer.capacity() > size * 2) {
            buffer.clear();
            buffer.limit(size);
            ByteBuffer slice = buffer.slice();
            buffer.limit(buffer.capacity()).position(size + 1);
            this.findSlot(buffer.slice());
            buffer = slice;
        } else {
            buffer.limit(size);
        }
        assert (buffer == null || buffer.remaining() == size);
        return buffer;
    }

    public long getSize() {
        return this.totalSize;
    }

    @Override
    public void reclaim() {
        this.totalSize = 0L;
        this.freeList.clear();
    }

    @Override
    public void returnBuffer(ByteBuffer buffer) {
        assert (this.zeroFrame(buffer));
        this.findSlot(buffer);
    }

    private void findSlot(ByteBuffer buffer) {
        buffer.clear();
        this.totalSize += (long)buffer.capacity();
        assert (this.checkReturn(buffer));
        while (buffer != null) {
            if (buffer.limit() == 0) {
                this.totalSize -= (long)buffer.capacity();
                return;
            }
            if ((buffer = this.freeList.put(buffer.limit(), buffer)) == null) continue;
            buffer.limit(buffer.limit() - 1);
        }
    }

    private boolean zeroFrame(ByteBuffer buffer) {
        buffer.clear();
        for (int x = 0; x < buffer.capacity(); ++x) {
            buffer.put(x, (byte)0);
        }
        return true;
    }

    private boolean frameIsZeroed(ByteBuffer buffer) {
        if (buffer == null) {
            return true;
        }
        buffer.clear();
        for (int x = 0; x < buffer.capacity(); ++x) {
            if (buffer.get(x) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean checkReturn(ByteBuffer buffer) {
        if (buffer == null) {
            return true;
        }
        for (ByteBuffer b : this.freeList.values()) {
            if (b != buffer) continue;
            return false;
        }
        return true;
    }
}

