/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.search;

import net.sf.ehcache.search.expression.AlwaysMatch;
import net.sf.ehcache.search.expression.And;
import net.sf.ehcache.search.expression.Between;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.expression.EqualTo;
import net.sf.ehcache.search.expression.GreaterThan;
import net.sf.ehcache.search.expression.GreaterThanOrEqual;
import net.sf.ehcache.search.expression.ILike;
import net.sf.ehcache.search.expression.InCollection;
import net.sf.ehcache.search.expression.LessThan;
import net.sf.ehcache.search.expression.LessThanOrEqual;
import net.sf.ehcache.search.expression.Not;
import net.sf.ehcache.search.expression.NotEqualTo;
import net.sf.ehcache.search.expression.NotILike;
import net.sf.ehcache.search.expression.Or;
import net.sf.ehcache.search.impl.BaseQueryInterpreter;
import org.terracotta.toolkit.search.AggregateFunction;
import org.terracotta.toolkit.search.Attribute;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.SearchException;
import org.terracotta.toolkit.search.SearchQueryResultSet;
import org.terracotta.toolkit.search.SortDirection;
import org.terracotta.toolkit.search.expression.Always;
import org.terracotta.toolkit.search.expression.BooleanClause;
import org.terracotta.toolkit.search.expression.Clause;
import org.terracotta.toolkit.search.expression.Equals;
import org.terracotta.toolkit.search.expression.Matches;
import org.terracotta.toolkit.search.expression.OneOf;
import org.terracotta.toolkit.search.expression.Range;
import org.terracotta.toolkit.search.expression.RelationalClause;

public class QueryInterpreter
extends BaseQueryInterpreter {
    private final QueryBuilder builder;
    private final ToolkitClauseProcessor clauseHelper = new ToolkitClauseProcessor();

    public QueryInterpreter(QueryBuilder builder) {
        this.builder = builder;
    }

    public SearchQueryResultSet executeQuery() {
        try {
            return this.builder.build().execute();
        }
        catch (SearchException e) {
            throw new net.sf.ehcache.search.SearchException(e.getMessage());
        }
    }

    @Override
    protected void maxResults(int maxResults) {
        this.builder.maxResults(maxResults);
    }

    @Override
    protected void includeKeys(boolean include) {
        this.builder.includeKeys(include);
    }

    @Override
    protected void includeValues(boolean include) {
        this.builder.includeValues(include);
    }

    @Override
    protected void max(String name) {
        this.builder.includeAggregator(new AggregateFunction[]{AggregateFunction.max((String)name)});
    }

    @Override
    protected void min(String name) {
        this.builder.includeAggregator(new AggregateFunction[]{AggregateFunction.min((String)name)});
    }

    @Override
    protected void sum(String name) {
        this.builder.includeAggregator(new AggregateFunction[]{AggregateFunction.sum((String)name)});
    }

    @Override
    protected void average(String name) {
        this.builder.includeAggregator(new AggregateFunction[]{AggregateFunction.average((String)name)});
    }

    @Override
    protected void count() {
        this.builder.includeAggregator(new AggregateFunction[]{AggregateFunction.count()});
    }

    @Override
    protected void attribute(String name) {
        this.builder.includeAttribute(new Attribute[]{new Attribute(name)});
    }

    @Override
    protected void attributeAscending(String name) {
        this.builder.addOrderBy(new Attribute(name), SortDirection.ASCENDING);
    }

    @Override
    protected void attributeDescending(String name) {
        this.builder.addOrderBy(new Attribute(name), SortDirection.DESCENDING);
    }

    @Override
    protected void groupBy(String name) {
        this.builder.addGroupBy(new Attribute[]{new Attribute(name)});
    }

    @Override
    protected void ilike(ILike criteria) {
        this.builder.addClause(this.clauseHelper.matches(criteria));
    }

    @Override
    protected void all() {
        this.builder.addClause((Clause)new Always());
    }

    @Override
    protected void and(And criteria) {
        this.builder.addClause(this.clauseHelper.and(criteria));
    }

    @Override
    protected void or(Or criteria) {
        this.builder.addClause(this.clauseHelper.or(criteria));
    }

    @Override
    protected void equalTo(EqualTo criteria) {
        this.builder.addClause(this.clauseHelper.equals(criteria));
    }

    @Override
    protected void notIlike(NotILike criteria) {
        this.builder.addClause(this.clauseHelper.doesNotMatch(criteria));
    }

    @Override
    protected void greaterThan(GreaterThan gt) {
        this.builder.addClause(this.clauseHelper.greaterThan(gt));
    }

    @Override
    protected void greaterThanEqual(GreaterThanOrEqual gte) {
        this.builder.addClause(this.clauseHelper.greaterThanOrEqual(gte));
    }

    @Override
    protected void between(Between c) {
        this.builder.addClause(this.clauseHelper.range(c));
    }

    @Override
    protected void notEqualTerm(NotEqualTo ne) {
        this.builder.addClause(this.clauseHelper.notEqualTo(ne));
    }

    @Override
    protected void lessThanEqual(LessThanOrEqual lte) {
        this.builder.addClause(this.clauseHelper.lessThanOrEqual(lte));
    }

    @Override
    protected void lessThan(LessThan lt) {
        this.builder.addClause(this.clauseHelper.lessThan(lt));
    }

    @Override
    protected void in(InCollection criteria) {
        this.builder.addClause(this.clauseHelper.oneOf(criteria));
    }

    private static final class ToolkitClauseProcessor {
        private ToolkitClauseProcessor() {
        }

        private Clause[] buildSubClauses(Criteria[] crits) {
            Clause[] c = new Clause[crits.length];
            int i = 0;
            for (Criteria crit : crits) {
                c[i++] = this.toClause(crit);
            }
            return c;
        }

        private Clause and(And criteria) {
            return new BooleanClause(BooleanClause.Operator.AND, this.buildSubClauses(criteria.getCriterion()));
        }

        private Clause not(Not criteria) {
            return new BooleanClause(BooleanClause.Operator.NOT, this.buildSubClauses(new Criteria[]{criteria.getCriteria()}));
        }

        private Clause or(Or criteria) {
            return new BooleanClause(BooleanClause.Operator.OR, this.buildSubClauses(criteria.getCriterion()));
        }

        private Clause notEqualTo(NotEqualTo ne) {
            return new BooleanClause(BooleanClause.Operator.NOT, new Clause[]{new Equals(ne.getAttributeName(), ne.getValue())});
        }

        private Clause equals(EqualTo eq) {
            return new Equals(eq.getAttributeName(), eq.getValue());
        }

        private Clause matches(ILike ilike) {
            return new Matches(ilike.getAttributeName(), ilike.getRegex());
        }

        private Clause doesNotMatch(NotILike c) {
            return new BooleanClause(BooleanClause.Operator.NOT, new Clause[]{new Matches(c.getAttributeName(), c.getRegex())});
        }

        private Clause range(Between c) {
            return new Range(c.getAttributeName(), (Object)c.getMin(), (Object)c.getMax(), c.isMinInclusive(), c.isMaxInclusive());
        }

        private Clause oneOf(InCollection c) {
            return new OneOf(c.getAttributeName(), c.values());
        }

        private Clause lessThan(LessThan c) {
            return RelationalClause.lt((String)c.getAttributeName(), (Object)c.getComparableValue());
        }

        private Clause greaterThan(GreaterThan c) {
            return RelationalClause.gt((String)c.getAttributeName(), (Object)c.getComparableValue());
        }

        private Clause lessThanOrEqual(LessThanOrEqual c) {
            return RelationalClause.lte((String)c.getAttributeName(), (Object)c.getComparableValue());
        }

        private Clause greaterThanOrEqual(GreaterThanOrEqual c) {
            return RelationalClause.gte((String)c.getAttributeName(), (Object)c.getComparableValue());
        }

        private Clause toClause(Criteria c) {
            if (c instanceof AlwaysMatch) {
                return new Always();
            }
            if (c instanceof And) {
                return this.and((And)c);
            }
            if (c instanceof Or) {
                return this.or((Or)c);
            }
            if (c instanceof NotEqualTo) {
                return this.notEqualTo((NotEqualTo)c);
            }
            if (c instanceof NotILike) {
                return this.doesNotMatch((NotILike)c);
            }
            if (c instanceof Between) {
                return this.range((Between)c);
            }
            if (c instanceof EqualTo) {
                return this.equals((EqualTo)c);
            }
            if (c instanceof ILike) {
                return this.matches((ILike)c);
            }
            if (c instanceof GreaterThan) {
                return this.greaterThan((GreaterThan)c);
            }
            if (c instanceof GreaterThanOrEqual) {
                return this.greaterThanOrEqual((GreaterThanOrEqual)c);
            }
            if (c instanceof InCollection) {
                return this.oneOf((InCollection)c);
            }
            if (c instanceof LessThan) {
                return this.lessThan((LessThan)c);
            }
            if (c instanceof LessThanOrEqual) {
                return this.lessThanOrEqual((LessThanOrEqual)c);
            }
            if (c instanceof Not) {
                return this.not((Not)c);
            }
            throw new net.sf.ehcache.search.SearchException("Unknown criteria type: " + c);
        }
    }
}

