/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.ehcachedx.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.terracotta.ehcachedx.util.VmVersion;
import sun.misc.VM;

public class Vm {
    public static final VmVersion VERSION = new VmVersion(System.getProperties());

    private Vm() {
    }

    public static int getMegaVersion() {
        return VERSION.getMegaVersion();
    }

    public static int getMajorVersion() {
        return VERSION.getMajorVersion();
    }

    public static int getMinorVersion() {
        return VERSION.getMinorVersion();
    }

    public static String getPatchLevel() {
        return VERSION.getPatchLevel();
    }

    public static boolean isJDK14() {
        return VERSION.isJDK14();
    }

    public static boolean isJDK15() {
        return VERSION.isJDK15();
    }

    public static boolean isJDK16() {
        return VERSION.isJDK16();
    }

    public static boolean isJDK17() {
        return VERSION.isJDK17();
    }

    public static boolean isJDK15Compliant() {
        return VERSION.getMajorVersion() >= 5;
    }

    public static boolean isJDK16Compliant() {
        return VERSION.getMajorVersion() >= 6;
    }

    public static boolean isIBM() {
        if (VERSION == null) {
            return VmVersion.thisVMisIBM();
        }
        return VERSION.isIBM();
    }

    public static void assertIsIbm() {
        if (!Vm.isIBM()) {
            throw new AssertionError((Object)"not ibm");
        }
    }

    public static boolean isJRockit() {
        return VERSION.isJRockit();
    }

    public static boolean isAzul() {
        return VERSION.isAzul();
    }

    public static boolean isHotSpot() {
        return VERSION.isHotSpot();
    }

    public static int dataModel() {
        try {
            if (Vm.isAzul()) {
                return 64;
            }
            String dataModelString = System.getProperty("sun.arch.data.model", "0");
            return Integer.parseInt(dataModelString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long maxDirectMemory() {
        if (Vm.isJRockit()) {
            return Vm.extractMaxDirectMemoryJrockit();
        }
        if (Vm.isHotSpot() || Vm.isIBM()) {
            return VM.maxDirectMemory();
        }
        throw new RuntimeException("Don't know how to find maxDirectMemory for this VM");
    }

    public static long reservedDirectMemory() {
        if (Vm.isJRockit()) {
            return Vm.reservedDirectMemoryJrockit();
        }
        if (Vm.isHotSpot() || Vm.isIBM()) {
            return Vm.reservedDirectMemorySun();
        }
        throw new RuntimeException("Don't know how to find reservedDirectMemory for this VM");
    }

    private static long extractMaxDirectMemoryJrockit() {
        try {
            Class<?> jrockitMemoryClass = Class.forName("jrockit.vm.Memory");
            Method reserveDirectMemoryMethod = jrockitMemoryClass.getDeclaredMethod("reserveDirectMemory", Long.TYPE);
            reserveDirectMemoryMethod.invoke(null, 0L);
            Field maxDirectMemoryField = jrockitMemoryClass.getDeclaredField("maxDirectMemory");
            maxDirectMemoryField.setAccessible(true);
            return maxDirectMemoryField.getLong(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read max direct memory", e);
        }
    }

    private static long reservedDirectMemorySun() {
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits");
            Field reservedMemoryField = bitsClass.getDeclaredField("reservedMemory");
            reservedMemoryField.setAccessible(true);
            return reservedMemoryField.getLong(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read reservedMemory", e);
        }
    }

    private static long reservedDirectMemoryJrockit() {
        try {
            Class<?> jrockitMemoryClass = Class.forName("jrockit.vm.Memory");
            Method getReservedDirectMemoryMethod = jrockitMemoryClass.getDeclaredMethod("getReservedDirectMemory", new Class[0]);
            Long rv = (Long)getReservedDirectMemoryMethod.invoke(null, new Object[0]);
            return rv;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read reservedMemory", e);
        }
    }
}

