/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.TerracottaClusteredInstanceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredCacheDestroyer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusteredCacheDestroyer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroyCache(TerracottaClientConfiguration clientConfiguration, String cacheManagerName, String cacheName) {
        Configuration configuration = new Configuration();
        if (cacheManagerName != null) {
            configuration.name(cacheManagerName);
        }
        CacheManager cm = CacheManager.create(configuration);
        try {
            ClusteredInstanceFactory factory = TerracottaClusteredInstanceHelper.getInstance().newClusteredInstanceFactory(Collections.EMPTY_MAP, clientConfiguration);
            try {
                factory.getTopology().addTopologyListener(new NodeJoinLogger(factory.getTopology().getCurrentNode()));
                if (factory.getTopology().getNodes().size() != 1) {
                    throw new IllegalStateException("Can't destroy a clustered cache when more than one client is connected. Connected clients " + factory.getTopology().getNodes());
                }
                if (factory.destroyCache(cm.getName(), cacheName)) {
                    LOGGER.info("Cache '{}' successfully destroyed.", (Object)cacheName);
                } else {
                    LOGGER.warn("Cache '{}' does not exist. Please verify the name and try again.", (Object)cacheName);
                }
            }
            finally {
                factory.shutdown();
            }
        }
        finally {
            cm.shutdown();
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        File ehcacheXml;
        if (args.length != 2) {
            LOGGER.error("Usage: java -cp ehcache-ee.jar net.sf.ehcache.terracotta.ClusteredCacheDestroyer [path to ehcache.xml] [name of clustered cache]");
            System.exit(1);
        }
        if (!(ehcacheXml = new File(args[0])).exists() || !ehcacheXml.isFile()) {
            LOGGER.error("{} does not exist or is not a file.", (Object)ehcacheXml);
            System.exit(1);
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration(ehcacheXml);
        String cacheName = args[1];
        if (!configuration.getCacheConfigurations().containsKey(cacheName)) {
            LOGGER.error("{} does not name a cache in the specified ehcache xml.", (Object)cacheName);
            System.exit(1);
        }
        ClusteredCacheDestroyer.destroyCache(configuration.getTerracottaConfiguration(), configuration.getName(), cacheName);
    }

    private static class NodeJoinLogger
    implements ClusterTopologyListener {
        private final ClusterNode currentNode;

        private NodeJoinLogger(ClusterNode currentNode) {
            this.currentNode = currentNode;
        }

        @Override
        public void nodeJoined(ClusterNode node) {
            if (!this.currentNode.equals(node)) {
                LOGGER.warn("Node {} joined the cluster! Inconsistent cache behavior may occur.", (Object)node);
            }
        }

        @Override
        public void nodeLeft(ClusterNode node) {
        }

        @Override
        public void clusterOnline(ClusterNode node) {
        }

        @Override
        public void clusterOffline(ClusterNode node) {
        }

        @Override
        public void clusterRejoined(ClusterNode oldNode, ClusterNode newNode) {
        }
    }
}

