/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.AbstractPersistentConcurrentOffHeapMap;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.DiskWriteThreadPool;
import net.sf.ehcache.store.offheap.factories.EhcachePersistentSegmentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.observer.OperationObserver;

public class EhcachePersistentConcurrentOffHeapClockCache
extends AbstractPersistentConcurrentOffHeapMap<Serializable, Element> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheConcurrentOffHeapClockCache.class);
    private final DiskWriteThreadPool writePool;
    private final long diskSpoolBufferSize;
    private final String cacheName;
    private final Random rnd = new Random();
    private List<ReentrantReadWriteLock> locks;
    private volatile long averageMappingSize = -1L;

    public EhcachePersistentConcurrentOffHeapClockCache(RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, CacheConfiguration config, MappedPageSource source, DiskWriteThreadPool writePool, Factory<? extends PersistentStorageEngine<Serializable, Element>> storageEngineFactory, int initialTableSize, int concurrency) {
        super(new EhcachePersistentSegmentFactory(evictionListener, evictionObserver, source, storageEngineFactory, initialTableSize, config.getMaxEntriesLocalDisk(), true), concurrency, false);
        this.diskSpoolBufferSize = (long)config.getDiskSpoolBufferSizeMB() * 1024L * 1024L;
        this.writePool = writePool;
        this.cacheName = config.getName();
    }

    public EhcachePersistentConcurrentOffHeapClockCache(ObjectInput input, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, CacheConfiguration config, MappedPageSource source, DiskWriteThreadPool writePool, Factory<? extends PersistentStorageEngine<Serializable, Element>> storageEngineFactory, int initialTableSize) throws IOException {
        super(new EhcachePersistentSegmentFactory(evictionListener, evictionObserver, source, storageEngineFactory, initialTableSize, config.getMaxEntriesLocalDisk(), false), EhcachePersistentConcurrentOffHeapClockCache.readSegmentCount(input), false);
        this.diskSpoolBufferSize = (long)config.getDiskSpoolBufferSizeMB() * 1024L * 1024L;
        this.writePool = writePool;
        this.cacheName = config.getName();
    }

    public ReentrantReadWriteLock getLock(Object key) {
        return this.segmentFor(key).getLock();
    }

    public boolean bufferFull() {
        long estimatedQueueSize;
        boolean backedUp;
        if (this.averageMappingSize < 0L) {
            this.averageMappingSize = this.getAverageMappingSize();
        }
        boolean bl = backedUp = (estimatedQueueSize = this.writePool.getTotalQueueSize() * this.averageMappingSize) > this.diskSpoolBufferSize;
        if (backedUp) {
            this.averageMappingSize = this.getAverageMappingSize();
            LOGGER.debug("A back up on disk store puts occurred. Consider increasing diskSpoolBufferSizeMB for cache " + this.cacheName);
        }
        return backedUp;
    }

    private long getAverageMappingSize() {
        long size = this.getSize();
        if (size == 0L) {
            return -1L;
        }
        return this.getOccupiedMemory() / size;
    }

    public List<ReentrantReadWriteLock> getOrderedLocks() {
        List<ReentrantReadWriteLock> l = this.locks;
        return l == null ? (this.locks = this.generateLockList()) : l;
    }

    private List<ReentrantReadWriteLock> generateLockList() {
        ArrayList<ReentrantReadWriteLock> l = new ArrayList<ReentrantReadWriteLock>(this.segments.length);
        for (Segment c : this.segments) {
            l.add(c.getLock());
        }
        return Collections.unmodifiableList(l);
    }

    public boolean remove(Object key, Element element, ElementValueComparator comparator) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.remove(key, element, comparator);
    }

    public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
        EhcachePersistentSegmentFactory.EhcachePersistentSegment segment = (EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segmentFor(key);
        return segment.replace(key, oldValue, newValue, comparator);
    }

    public Element evictOne() {
        Element evicted;
        int start;
        int i;
        for (i = start = this.rnd.nextInt(this.segments.length); i < this.segments.length; ++i) {
            evicted = this.evictFromSegmentAt(i);
            if (evicted == null) continue;
            return evicted;
        }
        for (i = 0; i < start; ++i) {
            evicted = this.evictFromSegmentAt(i);
            if (evicted == null) continue;
            return evicted;
        }
        return null;
    }

    public Element getAndPin(Serializable key) {
        return (Element)this.segmentFor(key).getAndSetMetadata(key, 0x40000000, 0x40000000);
    }

    private Element evictFromSegmentAt(int segmentIdx) {
        if (this.segments[segmentIdx].getSize() == 0L) {
            return null;
        }
        return ((EhcachePersistentSegmentFactory.EhcachePersistentSegment)this.segments[segmentIdx]).evict();
    }

    public boolean isPinned(Object key) {
        Segment segment = this.segmentFor(key);
        return segment.getSize() != 0L && ((EhcachePersistentSegmentFactory.EhcachePersistentSegment)segment).isPinned(key);
    }
}

