/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.LuceneIndexManager;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.StackOperations;
import com.terracottatech.search.ValueType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.BooleanClause;
import org.terracotta.shaded.lucene.search.BooleanQuery;
import org.terracotta.shaded.lucene.search.MatchAllDocsQuery;
import org.terracotta.shaded.lucene.search.NumericRangeQuery;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.TermQuery;
import org.terracotta.shaded.lucene.search.TermRangeQuery;
import org.terracotta.shaded.lucene.search.WildcardQuery;
import org.terracotta.shaded.lucene.util.BytesRef;

public class LuceneQueryBuilder {
    private final List queryStack;
    private final Map<String, LuceneIndexManager.AttributeProperties> indexSchema;

    public LuceneQueryBuilder(List queryStack, Map<String, LuceneIndexManager.AttributeProperties> indexSchema) {
        this.queryStack = queryStack;
        this.indexSchema = indexSchema;
    }

    public Query buildQuery() throws IndexException {
        Stack<Group> stack = new Stack<Group>();
        Iterator iter = this.queryStack.iterator();
        while (iter.hasNext()) {
            Query query;
            StackOperations op = (StackOperations)((Object)iter.next());
            if (op == StackOperations.BEGIN_GROUP) {
                op = (StackOperations)((Object)iter.next());
                stack.push(new Group(op));
                continue;
            }
            if (op == StackOperations.END_GROUP) {
                query = ((Group)stack.pop()).query();
                if (stack.isEmpty()) {
                    return query;
                }
                ((Group)stack.peek()).add(query);
                continue;
            }
            query = this.processQuery(op, iter);
            if (stack.isEmpty()) {
                return query;
            }
            ((Group)stack.peek()).add(query);
        }
        if (!this.queryStack.isEmpty()) {
            throw new IndexException("Unexpected EOF in query stack: " + this.queryStack);
        }
        return new MatchAllDocsQuery();
    }

    private static BooleanClause.Occur occurFor(StackOperations op) {
        if (op == StackOperations.AND) {
            return BooleanClause.Occur.MUST;
        }
        if (op == StackOperations.OR) {
            return BooleanClause.Occur.SHOULD;
        }
        throw new AssertionError((Object)("operation: " + (Object)((Object)op)));
    }

    private Query processQuery(StackOperations operation, Iterator iter) throws IndexException {
        switch (operation) {
            case BETWEEN: {
                return this.processBetween(iter);
            }
            case GREATER_THAN: {
                return this.processGreaterThan(iter);
            }
            case GREATER_THAN_EQUAL: {
                return this.processGreaterThanEqual(iter);
            }
            case LESS_THAN: {
                return this.processLessThan(iter);
            }
            case LESS_THAN_EQUAL: {
                return this.processLessThanEqual(iter);
            }
            case ILIKE: {
                return this.processILike(iter);
            }
            case TERM: {
                return this.processTerm(iter);
            }
            case NOT_TERM: {
                return this.processNotTerm(iter);
            }
            case ALL: {
                return new MatchAllDocsQuery();
            }
            case NOT_ILIKE: {
                return this.processNotILike(iter);
            }
            case AND: 
            case OR: 
            case BEGIN_GROUP: 
            case END_GROUP: {
                throw new IndexException(operation.name() + " is not expected here");
            }
        }
        throw new AssertionError((Object)("operation: " + (Object)((Object)operation)));
    }

    private Query processBetween(Iterator iter) throws IndexException {
        NVPair minRange = (NVPair)iter.next();
        NVPair maxRange = (NVPair)iter.next();
        NVPair minInclusive = (NVPair)iter.next();
        NVPair maxInclusive = (NVPair)iter.next();
        this.verifyType(minRange);
        String name = minRange.getName();
        boolean minInclude = ((AbstractNVPair.BooleanNVPair)minInclusive).getValue();
        boolean maxInclude = ((AbstractNVPair.BooleanNVPair)maxInclusive).getValue();
        ValueType type = minRange.getType();
        switch (type) {
            case BOOLEAN: {
                Integer min = ((AbstractNVPair.BooleanNVPair)minRange).getValue() ? 1 : 0;
                Integer max = ((AbstractNVPair.BooleanNVPair)maxRange).getValue() ? 1 : 0;
                return NumericRangeQuery.newIntRange(name, min, max, minInclude, maxInclude);
            }
            case BYTE_ARRAY: {
                throw new IndexException(type.name() + " not supported");
            }
            case BYTE: {
                Integer min = ((AbstractNVPair.ByteNVPair)minRange).getValue();
                Integer max = ((AbstractNVPair.ByteNVPair)maxRange).getValue();
                return NumericRangeQuery.newIntRange(name, min, max, minInclude, maxInclude);
            }
            case CHAR: {
                Integer min = ((AbstractNVPair.CharNVPair)minRange).getValue();
                Integer max = ((AbstractNVPair.CharNVPair)maxRange).getValue();
                return NumericRangeQuery.newIntRange(name, min, max, minInclude, maxInclude);
            }
            case DOUBLE: {
                Double min = ((AbstractNVPair.DoubleNVPair)minRange).getValue();
                Double max = ((AbstractNVPair.DoubleNVPair)maxRange).getValue();
                return NumericRangeQuery.newDoubleRange(name, min, max, minInclude, maxInclude);
            }
            case FLOAT: {
                Float min = Float.valueOf(((AbstractNVPair.FloatNVPair)minRange).getValue());
                Float max = Float.valueOf(((AbstractNVPair.FloatNVPair)maxRange).getValue());
                return NumericRangeQuery.newFloatRange(name, min, max, minInclude, maxInclude);
            }
            case INT: {
                Integer min = ((AbstractNVPair.IntNVPair)minRange).getValue();
                Integer max = ((AbstractNVPair.IntNVPair)maxRange).getValue();
                return NumericRangeQuery.newIntRange(name, min, max, minInclude, maxInclude);
            }
            case LONG: {
                Long min = ((AbstractNVPair.LongNVPair)minRange).getValue();
                Long max = ((AbstractNVPair.LongNVPair)maxRange).getValue();
                return NumericRangeQuery.newLongRange(name, min, max, minInclude, maxInclude);
            }
            case SHORT: {
                Integer min = ((AbstractNVPair.ShortNVPair)minRange).getValue();
                Integer max = ((AbstractNVPair.ShortNVPair)maxRange).getValue();
                return NumericRangeQuery.newIntRange(name, min, max, minInclude, maxInclude);
            }
            case DATE: {
                Long min = ((AbstractNVPair.DateNVPair)minRange).getValue().getTime();
                Long max = ((AbstractNVPair.DateNVPair)maxRange).getValue().getTime();
                return NumericRangeQuery.newLongRange(name, min, max, minInclude, maxInclude);
            }
            case SQL_DATE: {
                Long min = ((AbstractNVPair.SqlDateNVPair)minRange).getValue().getTime();
                Long max = ((AbstractNVPair.SqlDateNVPair)maxRange).getValue().getTime();
                return NumericRangeQuery.newLongRange(name, min, max, minInclude, maxInclude);
            }
            case ENUM: {
                String min = AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)minRange);
                String max = AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)maxRange);
                return new TermRangeQuery(name, new BytesRef(min), new BytesRef(max), minInclude, maxInclude);
            }
            case STRING: {
                String min = ((AbstractNVPair.StringNVPair)minRange).getValue();
                String max = ((AbstractNVPair.StringNVPair)maxRange).getValue();
                return new TermRangeQuery(name, new BytesRef(min.toLowerCase()), new BytesRef(max.toLowerCase()), minInclude, maxInclude);
            }
            case NULL: {
                throw new IndexException(type.name() + " not supported");
            }
            case VALUE_ID: {
                throw new IndexException(type.name() + " not supported");
            }
        }
        throw new AssertionError(minRange);
    }

    private void verifyType(NVPair nvPair) throws IndexException {
        LuceneIndexManager.AttributeProperties attrProps = this.indexSchema.get(nvPair.getName());
        String typeString = LuceneIndexManager.getAttributeTypeString(nvPair);
        if (attrProps != null && !attrProps.getType().equals(typeString)) {
            throw new IndexException("Expected " + attrProps.getType() + " for attribute [" + nvPair.getName() + "], but was " + typeString);
        }
    }

    private Query processGreaterThan(Iterator iter) throws IndexException {
        NVPair greaterThanTerm = (NVPair)iter.next();
        return this.processAboveBelow(greaterThanTerm, false, false);
    }

    private Query processGreaterThanEqual(Iterator iter) throws IndexException {
        NVPair greaterThanEqualTerm = (NVPair)iter.next();
        return this.processAboveBelow(greaterThanEqualTerm, false, true);
    }

    private Query processLessThan(Iterator iter) throws IndexException {
        NVPair lessThanTerm = (NVPair)iter.next();
        return this.processAboveBelow(lessThanTerm, true, false);
    }

    private Query processLessThanEqual(Iterator iter) throws IndexException {
        NVPair lessThanEqualTerm = (NVPair)iter.next();
        return this.processAboveBelow(lessThanEqualTerm, true, true);
    }

    private Query processAboveBelow(NVPair term, boolean below, boolean equal) throws IndexException {
        boolean maxInclude;
        boolean minInclude;
        this.verifyType(term);
        if (below) {
            minInclude = true;
            maxInclude = equal;
        } else {
            minInclude = equal;
            maxInclude = true;
        }
        ValueType type = term.getType();
        switch (type) {
            case BOOLEAN: {
                Integer min;
                Integer n = below ? null : (min = Integer.valueOf(((AbstractNVPair.BooleanNVPair)term).getValue() ? 1 : 0));
                Integer max = below ? Integer.valueOf(((AbstractNVPair.BooleanNVPair)term).getValue() ? 1 : 0) : null;
                return NumericRangeQuery.newIntRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case BYTE_ARRAY: {
                throw new IndexException(type.name() + " not supported");
            }
            case BYTE: {
                Integer min = below ? null : Integer.valueOf(((AbstractNVPair.ByteNVPair)term).getValue());
                Integer max = below ? Integer.valueOf(((AbstractNVPair.ByteNVPair)term).getValue()) : null;
                return NumericRangeQuery.newIntRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case CHAR: {
                Integer min = below ? null : Integer.valueOf(((AbstractNVPair.CharNVPair)term).getValue());
                Integer max = below ? Integer.valueOf(((AbstractNVPair.CharNVPair)term).getValue()) : null;
                return NumericRangeQuery.newIntRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case DOUBLE: {
                Double min = below ? null : Double.valueOf(((AbstractNVPair.DoubleNVPair)term).getValue());
                Double max = below ? Double.valueOf(((AbstractNVPair.DoubleNVPair)term).getValue()) : null;
                return NumericRangeQuery.newDoubleRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case FLOAT: {
                Float min = below ? null : Float.valueOf(((AbstractNVPair.FloatNVPair)term).getValue());
                Float max = below ? Float.valueOf(((AbstractNVPair.FloatNVPair)term).getValue()) : null;
                return NumericRangeQuery.newFloatRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case INT: {
                Integer min = below ? null : Integer.valueOf(((AbstractNVPair.IntNVPair)term).getValue());
                Integer max = below ? Integer.valueOf(((AbstractNVPair.IntNVPair)term).getValue()) : null;
                return NumericRangeQuery.newIntRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case LONG: {
                Long min = below ? null : Long.valueOf(((AbstractNVPair.LongNVPair)term).getValue());
                Long max = below ? Long.valueOf(((AbstractNVPair.LongNVPair)term).getValue()) : null;
                return NumericRangeQuery.newLongRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case SHORT: {
                Integer min = below ? null : Integer.valueOf(((AbstractNVPair.ShortNVPair)term).getValue());
                Integer max = below ? Integer.valueOf(((AbstractNVPair.ShortNVPair)term).getValue()) : null;
                return NumericRangeQuery.newIntRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case DATE: {
                Long min = below ? null : Long.valueOf(((AbstractNVPair.DateNVPair)term).getValue().getTime());
                Long max = below ? Long.valueOf(((AbstractNVPair.DateNVPair)term).getValue().getTime()) : null;
                return NumericRangeQuery.newLongRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case SQL_DATE: {
                Long min = below ? null : Long.valueOf(((AbstractNVPair.SqlDateNVPair)term).getValue().getTime());
                Long max = below ? Long.valueOf(((AbstractNVPair.SqlDateNVPair)term).getValue().getTime()) : null;
                return NumericRangeQuery.newLongRange(term.getName(), min, max, minInclude, maxInclude);
            }
            case ENUM: {
                BytesRef min = below ? null : new BytesRef(AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)term));
                BytesRef max = below ? new BytesRef(AbstractNVPair.enumStorageString((AbstractNVPair.EnumNVPair)term)) : null;
                return new TermRangeQuery(term.getName(), min, max, minInclude, maxInclude);
            }
            case STRING: {
                BytesRef min = below ? null : new BytesRef(((AbstractNVPair.StringNVPair)term).getValue().toLowerCase());
                BytesRef max = below ? new BytesRef(((AbstractNVPair.StringNVPair)term).getValue().toLowerCase()) : null;
                return new TermRangeQuery(term.getName(), min, max, minInclude, maxInclude);
            }
            case NULL: {
                throw new IndexException(type.name() + " not supported");
            }
            case VALUE_ID: {
                throw new IndexException(type.name() + " not supported");
            }
        }
        throw new AssertionError((Object)term.toString());
    }

    private Query processILike(Iterator iter) {
        NVPair likeTerm = (NVPair)iter.next();
        return new WildcardQuery(new Term(likeTerm.getName(), likeTerm.valueAsString().toLowerCase()));
    }

    private Query processNotILike(Iterator iter) {
        NVPair likeTerm = (NVPair)iter.next();
        WildcardQuery wcq = new WildcardQuery(new Term(likeTerm.getName(), likeTerm.valueAsString().toLowerCase()));
        BooleanQuery query = new BooleanQuery();
        query.add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        query.add(wcq, BooleanClause.Occur.MUST_NOT);
        return query;
    }

    private Query processNotTerm(Iterator iter) throws IndexException {
        Query termQuery = this.processTerm(iter);
        BooleanQuery query = new BooleanQuery();
        query.add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        query.add(new BooleanClause(termQuery, BooleanClause.Occur.MUST_NOT));
        return query;
    }

    private Query processTerm(Iterator iter) throws IndexException {
        NVPair term = (NVPair)iter.next();
        this.verifyType(term);
        ValueType type = term.getType();
        switch (type) {
            case BOOLEAN: {
                AbstractNVPair.BooleanNVPair booleanNVPair = (AbstractNVPair.BooleanNVPair)term;
                int value = booleanNVPair.getValue() ? 1 : 0;
                return this.numericTermQuery(term.getName(), value);
            }
            case BYTE: {
                AbstractNVPair.ByteNVPair bytePair = (AbstractNVPair.ByteNVPair)term;
                return this.numericTermQuery(term.getName(), bytePair.getValue());
            }
            case BYTE_ARRAY: {
                throw new IndexException(type.name() + " not supported");
            }
            case CHAR: {
                AbstractNVPair.CharNVPair charPair = (AbstractNVPair.CharNVPair)term;
                return this.numericTermQuery(term.getName(), charPair.getValue());
            }
            case DATE: {
                AbstractNVPair.DateNVPair datePair = (AbstractNVPair.DateNVPair)term;
                long dateLong = datePair.getValue().getTime();
                return this.numericTermQuery(term.getName(), dateLong);
            }
            case SQL_DATE: {
                AbstractNVPair.SqlDateNVPair sqlDatePair = (AbstractNVPair.SqlDateNVPair)term;
                long sqlDateLong = sqlDatePair.getValue().getTime();
                return this.numericTermQuery(term.getName(), sqlDateLong);
            }
            case DOUBLE: {
                AbstractNVPair.DoubleNVPair doublePair = (AbstractNVPair.DoubleNVPair)term;
                return this.numericTermQuery(term.getName(), doublePair.getValue());
            }
            case ENUM: {
                AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)term;
                return new TermQuery(new Term(term.getName(), AbstractNVPair.enumStorageString(enumPair)));
            }
            case FLOAT: {
                AbstractNVPair.FloatNVPair floatPair = (AbstractNVPair.FloatNVPair)term;
                return this.numericTermQuery(term.getName(), floatPair.getValue());
            }
            case INT: {
                AbstractNVPair.IntNVPair intPair = (AbstractNVPair.IntNVPair)term;
                return this.numericTermQuery(term.getName(), intPair.getValue());
            }
            case LONG: {
                AbstractNVPair.LongNVPair longPair = (AbstractNVPair.LongNVPair)term;
                return this.numericTermQuery(term.getName(), longPair.getValue());
            }
            case SHORT: {
                AbstractNVPair.ShortNVPair shortPair = (AbstractNVPair.ShortNVPair)term;
                return this.numericTermQuery(term.getName(), shortPair.getValue());
            }
            case STRING: {
                break;
            }
            case NULL: {
                throw new IndexException(type.name() + " not supported");
            }
            case VALUE_ID: {
                throw new IndexException(type.name() + " not supported");
            }
        }
        return new TermQuery(new Term(term.getName(), term.valueAsString().toLowerCase()));
    }

    private Query numericTermQuery(String name, double value) {
        return NumericRangeQuery.newDoubleRange(name, value, value, true, true);
    }

    private Query numericTermQuery(String name, float value) {
        return NumericRangeQuery.newFloatRange(name, Float.valueOf(value), Float.valueOf(value), true, true);
    }

    private Query numericTermQuery(String name, int value) {
        return NumericRangeQuery.newIntRange(name, value, value, true, true);
    }

    private Query numericTermQuery(String name, long value) {
        return NumericRangeQuery.newLongRange(name, value, value, true, true);
    }

    private static class Group {
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();
        private final StackOperations op;

        Group(StackOperations op) {
            this.op = op;
        }

        Query query() {
            BooleanQuery query = new BooleanQuery();
            for (BooleanClause clause : this.clauses) {
                query.add(clause);
            }
            return query;
        }

        void add(Query query) {
            this.clauses.add(new BooleanClause(query, LuceneQueryBuilder.occurFor(this.op)));
        }
    }
}

