/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.portability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import java.nio.ByteBuffer;

public class BooleanPortability
implements Portability<Boolean> {
    public static final BooleanPortability INSTANCE = new BooleanPortability();
    private static final ByteBuffer TRUE = ByteBuffer.allocateDirect(1);
    private static final ByteBuffer FALSE = ByteBuffer.allocateDirect(1);

    private BooleanPortability() {
    }

    @Override
    public ByteBuffer encode(Boolean object) {
        return object != false ? TRUE.duplicate() : FALSE.duplicate();
    }

    @Override
    public Boolean decode(ByteBuffer buffer) {
        if (buffer.get(0) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return object.equals(this.decode(buffer));
    }

    static {
        TRUE.put((byte)1).flip();
        FALSE.put((byte)0).flip();
    }
}

