/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.PointerSize;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.util.Factory;

public class CompressingOffHeapBufferStorageEngine<K, V>
extends OffHeapBufferStorageEngine<K, V> {
    private static final float COMPRESS_THRESHOLD = 0.75f;

    public static <K, V> Factory<CompressingOffHeapBufferStorageEngine<K, V>> createCompressingFactory(final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<CompressingOffHeapBufferStorageEngine<K, V>>(){

            @Override
            public CompressingOffHeapBufferStorageEngine<K, V> newInstance() {
                return new CompressingOffHeapBufferStorageEngine(width, source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public static <K, V> Factory<CompressingOffHeapBufferStorageEngine<K, V>> createCompressingFactory(final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<CompressingOffHeapBufferStorageEngine<K, V>>(){

            @Override
            public CompressingOffHeapBufferStorageEngine<K, V> newInstance() {
                return new CompressingOffHeapBufferStorageEngine(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public CompressingOffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        super(width, source, pageSize, keyPortability, valuePortability);
    }

    public CompressingOffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        super(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability);
    }

    public CompressingOffHeapBufferStorageEngine(PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(width, source, pageSize, keyPortability, valuePortability, thief, victim);
    }

    public CompressingOffHeapBufferStorageEngine(PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim);
    }

    @Override
    protected void free(long address) {
        super.free(address);
        this.compress();
    }

    private boolean compress() {
        float occupation = (float)this.storageArea.getOccupiedMemory() / (float)this.storageArea.getLastUsedAddress();
        if (occupation < 0.75f) {
            long lastAddress = this.storageArea.getLastUsedPointer();
            int hashCode = this.readPojoHash(lastAddress);
            Long compressed = this.writeMappingBuffers(this.readKeyBuffer(lastAddress), this.readValueBuffer(lastAddress), hashCode);
            if (compressed == null) {
                return false;
            }
            if (compressed < lastAddress && this.owner.updateEncoding(hashCode, lastAddress, compressed, -1L)) {
                super.free(lastAddress);
                return true;
            }
            super.free(compressed);
            return false;
        }
        return false;
    }
}

