/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.WrappingChunk;
import com.terracottatech.frs.io.nio.AbstractReadbackStrategy;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class MappedReadbackStrategy
extends AbstractReadbackStrategy {
    private final MappedByteBuffer src;
    private final ListIterator<Chunk> chunks;
    private final Direction queueDirection;

    public MappedReadbackStrategy(MappedByteBuffer data, Direction direction) throws IOException {
        this.src = data;
        this.queueDirection = direction;
        ArrayList<Long> jumps = this.readJumpList(new WrappingChunk(this.src));
        LinkedList<WrappingChunk> list = new LinkedList<WrappingChunk>();
        if (jumps == null) {
            WrappingChunk buf = new WrappingChunk(data);
            ByteBuffer[] chunk = this.readChunk(buf);
            while (chunk != null) {
                if (this.queueDirection == Direction.REVERSE) {
                    list.push(new WrappingChunk(chunk));
                } else {
                    list.add(new WrappingChunk(chunk));
                }
                chunk = this.readChunk(buf);
            }
        } else {
            Long last = 42L;
            for (Long next : jumps) {
                try {
                    this.src.clear().position(last.intValue() + 12).limit(next.intValue() - 20);
                    if (this.queueDirection == Direction.REVERSE) {
                        list.push(new WrappingChunk(this.src.slice()));
                    } else {
                        list.add(new WrappingChunk(this.src.slice()));
                    }
                }
                catch (Throwable t) {
                    throw new AssertionError((Object)t);
                }
                last = next;
            }
            this.src.position(42);
        }
        this.chunks = list.listIterator();
    }

    private boolean checkQueue(List<Chunk> got) throws IOException {
        ArrayList<WrappingChunk> list = new ArrayList<WrappingChunk>();
        this.src.clear().position(42);
        Chunk buf = this.getBuffer();
        ByteBuffer[] chunk = this.readChunk(buf);
        while (chunk != null) {
            list.add(new WrappingChunk(chunk));
            chunk = this.readChunk(buf);
        }
        if (got != null) {
            if (got.size() != list.size()) {
                System.out.println(got.size() + " " + list.size());
                return false;
            }
            for (int x = 0; x < got.size(); ++x) {
                if (got.get(x).remaining() == ((Chunk)list.get(x)).remaining()) continue;
                System.out.println(x + " " + got.get(x).remaining() + " " + ((Chunk)list.get(x)).remaining());
                return false;
            }
        }
        return super.isConsistent();
    }

    @Override
    public boolean isConsistent() {
        try {
            return this.checkQueue(null);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public Chunk getBuffer() {
        return new WrappingChunk(this.src);
    }

    @Override
    public boolean hasMore(Direction dir) throws IOException {
        if (dir == this.queueDirection && this.chunks.hasNext()) {
            return true;
        }
        return dir != this.queueDirection && this.chunks.hasPrevious();
    }

    @Override
    public Chunk iterate(Direction dir) throws IOException {
        if (dir == this.queueDirection && this.chunks.hasNext()) {
            return this.chunks.next();
        }
        if (dir != this.queueDirection && this.chunks.hasPrevious()) {
            return this.chunks.previous();
        }
        return null;
    }
}

