/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.terracotta.shaded.lucene.index.AtomicReader;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.search.BitsFilteredDocIdSet;
import org.terracotta.shaded.lucene.search.DocIdSet;
import org.terracotta.shaded.lucene.search.DocIdSetIterator;
import org.terracotta.shaded.lucene.search.Filter;
import org.terracotta.shaded.lucene.util.Bits;
import org.terracotta.shaded.lucene.util.FixedBitSet;

public class CachingWrapperFilter
extends Filter {
    private final Filter filter;
    private final Map<Object, DocIdSet> cache = Collections.synchronizedMap(new WeakHashMap());
    private final boolean recacheDeletes;
    int hitCount;
    int missCount;

    public CachingWrapperFilter(Filter filter) {
        this(filter, false);
    }

    public CachingWrapperFilter(Filter filter, boolean recacheDeletes) {
        this.filter = filter;
        this.recacheDeletes = recacheDeletes;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, AtomicReader reader) throws IOException {
        if (docIdSet == null) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        if (it == null) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        bits.or(it);
        return bits;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Bits cacheAcceptDocs;
        Object key;
        boolean doCacheAcceptDocs;
        AtomicReader reader = context.reader();
        Bits liveDocs = reader.getLiveDocs();
        boolean bl = doCacheAcceptDocs = this.recacheDeletes && acceptDocs == liveDocs;
        if (doCacheAcceptDocs) {
            assert (acceptDocs == liveDocs);
            key = reader.getCombinedCoreAndDeletesKey();
            cacheAcceptDocs = acceptDocs;
        } else {
            key = reader.getCoreCacheKey();
            cacheAcceptDocs = null;
        }
        DocIdSet docIdSet = this.cache.get(key);
        if (docIdSet != null) {
            ++this.hitCount;
        } else {
            ++this.missCount;
            docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(context, cacheAcceptDocs), reader);
            this.cache.put(key, docIdSet);
        }
        if (doCacheAcceptDocs) {
            return docIdSet;
        }
        return BitsFilteredDocIdSet.wrap(docIdSet, acceptDocs);
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ",recacheDeletes=" + this.recacheDeletes + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        CachingWrapperFilter other = (CachingWrapperFilter)o;
        return this.filter.equals(other.filter) && this.recacheDeletes == other.recacheDeletes;
    }

    public int hashCode() {
        return (this.filter.hashCode() ^ 0x1117BF25) + (this.recacheDeletes ? 0 : 1);
    }
}

