/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40.values;

import java.io.IOException;
import java.util.Comparator;
import org.terracotta.shaded.lucene.codecs.DocValuesConsumer;
import org.terracotta.shaded.lucene.codecs.PerDocConsumer;
import org.terracotta.shaded.lucene.codecs.PerDocProducerBase;
import org.terracotta.shaded.lucene.codecs.lucene40.values.Writer;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.PerDocWriteState;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.Counter;

public abstract class DocValuesWriterBase
extends PerDocConsumer {
    protected final String segmentName;
    private final Counter bytesUsed;
    protected final IOContext context;
    private final float acceptableOverheadRatio;
    public static final String INDEX_EXTENSION = "idx";
    public static final String DATA_EXTENSION = "dat";

    protected DocValuesWriterBase(PerDocWriteState state) {
        this(state, 0.5f);
    }

    protected DocValuesWriterBase(PerDocWriteState state, float acceptableOverheadRatio) {
        this.segmentName = state.segmentInfo.name;
        this.bytesUsed = state.bytesUsed;
        this.context = state.context;
        this.acceptableOverheadRatio = acceptableOverheadRatio;
    }

    protected abstract Directory getDirectory() throws IOException;

    @Override
    public void close() throws IOException {
    }

    @Override
    public DocValuesConsumer addValuesField(DocValues.Type valueType, FieldInfo field) throws IOException {
        return Writer.create(valueType, PerDocProducerBase.docValuesId(this.segmentName, field.number), this.getDirectory(), this.getComparator(), this.bytesUsed, this.context, this.acceptableOverheadRatio);
    }

    public Comparator<BytesRef> getComparator() throws IOException {
        return BytesRef.getUTF8SortedAsUnicodeComparator();
    }
}

