/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.embedded;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.terracotta.management.embedded.FilterDetail;
import org.terracotta.management.embedded.StandaloneServerInterface;

public final class StandaloneServer
implements StandaloneServerInterface {
    public static final String EMBEDDED_CTXT = "/tc-management-api";
    private final List<FilterDetail> filterDetails;
    private final List<ServletContextListener> servletListeners;
    private volatile Server server;
    private final String basePackage;
    private final String host;
    private final int port;
    private final SSLContext sslCtxt;
    private final boolean needClientAuth;

    public StandaloneServer(List<FilterDetail> filterDetails, List<ServletContextListener> servletListeners, String basePackage, String host, int port, SSLContext sslCtxt, boolean needClientAuth) {
        this.filterDetails = filterDetails;
        this.servletListeners = servletListeners;
        this.basePackage = basePackage;
        this.host = host;
        this.port = port;
        this.sslCtxt = sslCtxt;
        this.needClientAuth = needClientAuth;
    }

    public void start() throws Exception {
        if (this.basePackage == null) {
            throw new IllegalArgumentException("basePackage must be set");
        }
        if (this.port == 0) {
            throw new IllegalArgumentException("port must be set");
        }
        if (this.server != null) {
            throw new IllegalStateException("server already started");
        }
        try {
            SelectChannelConnector connector;
            this.server = new Server(this.port);
            if (this.sslCtxt != null) {
                SslContextFactory sslCtxtFact = new SslContextFactory();
                sslCtxtFact.setSslContext(this.sslCtxt);
                sslCtxtFact.setNeedClientAuth(this.needClientAuth);
                connector = new SslSelectChannelConnector(sslCtxtFact);
            } else {
                connector = new SelectChannelConnector();
            }
            connector.setHost(this.host);
            connector.setPort(this.port);
            this.server.setConnectors(new Connector[]{connector});
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath(EMBEDDED_CTXT);
            this.server.setHandler((Handler)context);
            ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer());
            servletHolder.setInitParameter("com.sun.jersey.config.property.packages", this.basePackage);
            servletHolder.setInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
            context.addServlet(servletHolder, "/*");
            if (this.servletListeners != null) {
                context.setEventListeners(this.servletListeners.toArray(new EventListener[0]));
            }
            if (this.filterDetails != null) {
                for (FilterDetail f : this.filterDetails) {
                    FilterHolder filterHolder = new FilterHolder(f.getFilter());
                    EnumSet<DispatcherType> dTypes = null;
                    if (f.getDispatcherNames() != null) {
                        dTypes = EnumSet.noneOf(DispatcherType.class);
                        for (String dn : f.getDispatcherNames()) {
                            dTypes.add(DispatcherType.valueOf((String)dn));
                        }
                    }
                    context.addFilter(filterHolder, f.getPathSpec(), dTypes);
                }
            }
            this.server.start();
        }
        catch (Exception e) {
            this.server = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
            this.server.join();
        }
        finally {
            this.server = null;
        }
    }
}

