/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ajax;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.ajax.JSONPojoConvertor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONPojoConvertor
implements JSON.Convertor {
    private static final Logger LOG = Log.getLogger(JSONPojoConvertor.class);
    public static final Object[] GETTER_ARG = new Object[0];
    public static final Object[] NULL_ARG = new Object[]{null};
    private static final Map<Class<?>, NumberType> __numberTypes = new HashMap();
    protected boolean _fromJSON;
    protected Class<?> _pojoClass;
    protected Map<String, Method> _getters = new HashMap();
    protected Map<String, Setter> _setters = new HashMap();
    protected Set<String> _excluded;
    public static final NumberType SHORT = new /* Unavailable Anonymous Inner Class!! */;
    public static final NumberType INTEGER = new /* Unavailable Anonymous Inner Class!! */;
    public static final NumberType FLOAT = new /* Unavailable Anonymous Inner Class!! */;
    public static final NumberType LONG = new /* Unavailable Anonymous Inner Class!! */;
    public static final NumberType DOUBLE = new /* Unavailable Anonymous Inner Class!! */;

    public static NumberType getNumberType(Class<?> clazz) {
        return (NumberType)__numberTypes.get(clazz);
    }

    public JSONPojoConvertor(Class<?> pojoClass) {
        this(pojoClass, (Set)null, true);
    }

    public JSONPojoConvertor(Class<?> pojoClass, String[] excluded) {
        this(pojoClass, new HashSet<String>(Arrays.asList(excluded)), true);
    }

    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded) {
        this(pojoClass, excluded, true);
    }

    public JSONPojoConvertor(Class<?> pojoClass, Set<String> excluded, boolean fromJSON) {
        this._pojoClass = pojoClass;
        this._excluded = excluded;
        this._fromJSON = fromJSON;
        this.init();
    }

    public JSONPojoConvertor(Class<?> pojoClass, boolean fromJSON) {
        this(pojoClass, (Set)null, fromJSON);
    }

    protected void init() {
        Method[] methods = this._pojoClass.getMethods();
        block4: for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (Modifier.isStatic(m.getModifiers()) || m.getDeclaringClass() == Object.class) continue;
            String name = m.getName();
            switch (m.getParameterTypes().length) {
                case 0: {
                    if (m.getReturnType() == null) continue block4;
                    if (name.startsWith("is") && name.length() > 2) {
                        name = name.substring(2, 3).toLowerCase() + name.substring(3);
                    } else {
                        if (!name.startsWith("get") || name.length() <= 3) continue block4;
                        name = name.substring(3, 4).toLowerCase() + name.substring(4);
                    }
                    if (!this.includeField(name, m)) continue block4;
                    this.addGetter(name, m);
                    continue block4;
                }
                case 1: {
                    if (!name.startsWith("set") || name.length() <= 3 || !this.includeField(name = name.substring(3, 4).toLowerCase() + name.substring(4), m)) continue block4;
                    this.addSetter(name, m);
                }
            }
        }
    }

    protected void addGetter(String name, Method method) {
        this._getters.put(name, method);
    }

    protected void addSetter(String name, Method method) {
        this._setters.put(name, new Setter(name, method));
    }

    protected Setter getSetter(String name) {
        return (Setter)this._setters.get(name);
    }

    protected boolean includeField(String name, Method m) {
        return this._excluded == null || !this._excluded.contains(name);
    }

    protected int getExcludedCount() {
        return this._excluded == null ? 0 : this._excluded.size();
    }

    public Object fromJSON(Map object) {
        Object obj = null;
        try {
            obj = this._pojoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setProps(obj, object);
        return obj;
    }

    public int setProps(Object obj, Map<?, ?> props) {
        int count = 0;
        for (Map.Entry<?, ?> entry : props.entrySet()) {
            Setter setter = this.getSetter((String)entry.getKey());
            if (setter == null) continue;
            try {
                setter.invoke(obj, entry.getValue());
                ++count;
            }
            catch (Exception e) {
                LOG.warn(this._pojoClass.getName() + "#" + setter.getPropertyName() + " not set from " + entry.getValue().getClass().getName() + "=" + entry.getValue().toString(), new Object[0]);
                this.log((Throwable)e);
            }
        }
        return count;
    }

    public void toJSON(Object obj, JSON.Output out) {
        if (this._fromJSON) {
            out.addClass(this._pojoClass);
        }
        for (Map.Entry entry : this._getters.entrySet()) {
            try {
                out.add((String)entry.getKey(), ((Method)entry.getValue()).invoke(obj, GETTER_ARG));
            }
            catch (Exception e) {
                LOG.warn("{} property '{}' excluded. (errors)", new Object[]{this._pojoClass.getName(), entry.getKey()});
                this.log((Throwable)e);
            }
        }
    }

    protected void log(Throwable t) {
        LOG.ignore(t);
    }

    static /* synthetic */ Map access$000() {
        return __numberTypes;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static {
        __numberTypes.put(Short.class, SHORT);
        __numberTypes.put(Short.TYPE, SHORT);
        __numberTypes.put(Integer.class, INTEGER);
        __numberTypes.put(Integer.TYPE, INTEGER);
        __numberTypes.put(Long.class, LONG);
        __numberTypes.put(Long.TYPE, LONG);
        __numberTypes.put(Float.class, FLOAT);
        __numberTypes.put(Float.TYPE, FLOAT);
        __numberTypes.put(Double.class, DOUBLE);
        __numberTypes.put(Double.TYPE, DOUBLE);
    }
}

