/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jetty.util.ByteArrayOutputStream2;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class UrlEncoded
extends MultiMap
implements Cloneable {
    private static final Logger LOG = Log.getLogger(UrlEncoded.class);
    public static final String ENCODING = System.getProperty("org.eclipse.jetty.util.UrlEncoding.charset", "UTF-8");

    public UrlEncoded(UrlEncoded url) {
        super((MultiMap)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s) {
        super(6);
        this.decode(s, ENCODING);
    }

    public UrlEncoded(String s, String charset) {
        super(6);
        this.decode(s, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo((String)query, (MultiMap)this, (String)ENCODING, (int)-1);
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo((String)query, (MultiMap)this, (String)charset, (int)-1);
    }

    public String encode() {
        return this.encode(ENCODING, false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    public synchronized String encode(String charset, boolean equalsForNullValue) {
        return UrlEncoded.encode((MultiMap)this, (String)charset, (boolean)equalsForNullValue);
    }

    public static String encode(MultiMap map, String charset, boolean equalsForNullValue) {
        if (charset == null) {
            charset = ENCODING;
        }
        StringBuilder result = new StringBuilder(128);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = entry.getKey().toString();
            Object list = entry.getValue();
            int s = LazyList.size(list);
            if (s == 0) {
                result.append(UrlEncoded.encodeString((String)key, (String)charset));
                if (equalsForNullValue) {
                    result.append('=');
                }
            } else {
                for (int i = 0; i < s; ++i) {
                    if (i > 0) {
                        result.append('&');
                    }
                    Object val = LazyList.get(list, (int)i);
                    result.append(UrlEncoded.encodeString((String)key, (String)charset));
                    if (val != null) {
                        String str = val.toString();
                        if (str.length() > 0) {
                            result.append('=');
                            result.append(UrlEncoded.encodeString((String)str, (String)charset));
                            continue;
                        }
                        if (!equalsForNullValue) continue;
                        result.append('=');
                        continue;
                    }
                    if (!equalsForNullValue) continue;
                    result.append('=');
                }
            }
            if (!iter.hasNext()) continue;
            result.append('&');
        }
        return result.toString();
    }

    public static void decodeTo(String content, MultiMap map, String charset) {
        UrlEncoded.decodeTo((String)content, (MultiMap)map, (String)charset, (int)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset, int maxKeys) {
        if (charset == null) {
            charset = ENCODING;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            block9: for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        int l = i - mark - 1;
                        value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)content, (int)(mark + 1), (int)l, (String)charset) : content.substring(mark + 1, i));
                        mark = i;
                        encoded = false;
                        if (key != null) {
                            map.add((Object)key, (Object)value);
                        } else if (value != null && value.length() > 0) {
                            map.add((Object)value, (Object)"");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) continue block9;
                        LOG.warn("maxFormKeys limit exceeded keys>{}", new Object[]{maxKeys});
                        return;
                    }
                    case '=': {
                        if (key != null) continue block9;
                        key = encoded ? UrlEncoded.decodeString((String)content, (int)(mark + 1), (int)(i - mark - 1), (String)charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        continue block9;
                    }
                    case '+': {
                        encoded = true;
                        continue block9;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
            }
            if (key != null) {
                int l = content.length() - mark - 1;
                value = l == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)content, (int)(mark + 1), (int)l, (String)charset) : content.substring(mark + 1));
                map.add((Object)key, (Object)value);
            } else if (mark < content.length()) {
                String string = key = encoded ? UrlEncoded.decodeString((String)content, (int)(mark + 1), (int)(content.length() - mark - 1), (String)charset) : content.substring(mark + 1);
                if (key != null && key.length() > 0) {
                    map.add((Object)key, (Object)"");
                }
            }
        }
    }

    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap map) {
        UrlEncoded.decodeUtf8To((byte[])raw, (int)offset, (int)length, (MultiMap)map, (Utf8StringBuilder)new Utf8StringBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(byte[] raw, int offset, int length, MultiMap map, Utf8StringBuilder buffer) {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int end = offset + length;
            block11: for (int i = offset; i < end; ++i) {
                byte b = raw[i];
                try {
                    switch ((char)(0xFF & b)) {
                        case '&': {
                            value = buffer.length() == 0 ? "" : buffer.toString();
                            buffer.reset();
                            if (key != null) {
                                map.add((Object)key, (Object)value);
                            } else if (value != null && value.length() > 0) {
                                map.add((Object)value, (Object)"");
                            }
                            key = null;
                            value = null;
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append(b);
                                break;
                            }
                            key = buffer.toString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            if (i + 2 >= end) continue block11;
                            buffer.append((byte)((TypeUtil.convertHexDigit((byte)raw[++i]) << 4) + TypeUtil.convertHexDigit((byte)raw[++i])));
                            break;
                        }
                        default: {
                            buffer.append(b);
                            break;
                        }
                    }
                    continue;
                }
                catch (Utf8Appendable.NotUtf8Exception e) {
                    LOG.warn(e.toString(), new Object[0]);
                    LOG.debug((Throwable)e);
                }
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.reset();
                map.add(key, (Object)value);
            } else if (buffer.length() > 0) {
                map.add((Object)buffer.toString(), (Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode88591To(InputStream in, MultiMap map, int maxLength, int maxKeys) throws IOException {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int b;
            StringBuffer buffer = new StringBuffer();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                switch ((char)b) {
                    case '&': {
                        value = buffer.length() == 0 ? "" : buffer.toString();
                        buffer.setLength(0);
                        if (key != null) {
                            map.add((Object)key, (Object)value);
                        } else if (value != null && value.length() > 0) {
                            map.add((Object)value, (Object)"");
                        }
                        key = null;
                        value = null;
                        if (maxKeys <= 0 || map.size() <= maxKeys) break;
                        LOG.warn("maxFormKeys limit exceeded keys>{}", new Object[]{maxKeys});
                        return;
                    }
                    case '=': {
                        if (key != null) {
                            buffer.append((char)b);
                            break;
                        }
                        key = buffer.toString();
                        buffer.setLength(0);
                        break;
                    }
                    case '+': {
                        buffer.append(' ');
                        break;
                    }
                    case '%': {
                        int dh = in.read();
                        int dl = in.read();
                        if (dh < 0 || dl < 0) break;
                        buffer.append((char)((TypeUtil.convertHexDigit((byte)((byte)dh)) << 4) + TypeUtil.convertHexDigit((byte)((byte)dl))));
                        break;
                    }
                    default: {
                        buffer.append((char)b);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.setLength(0);
                map.add((Object)key, (Object)value);
            } else if (buffer.length() > 0) {
                map.add((Object)buffer.toString(), (Object)"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(InputStream in, MultiMap map, int maxLength, int maxKeys) throws IOException {
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int b;
            Utf8StringBuilder buffer = new Utf8StringBuilder();
            String key = null;
            String value = null;
            int totalLength = 0;
            while ((b = in.read()) >= 0) {
                try {
                    switch ((char)b) {
                        case '&': {
                            value = buffer.length() == 0 ? "" : buffer.toString();
                            buffer.reset();
                            if (key != null) {
                                map.add((Object)key, (Object)value);
                            } else if (value != null && value.length() > 0) {
                                map.add((Object)value, (Object)"");
                            }
                            key = null;
                            value = null;
                            if (maxKeys > 0 && map.size() > maxKeys) {
                                LOG.warn("maxFormKeys limit exceeded keys>{}", new Object[]{maxKeys});
                                return;
                            }
                            break;
                        }
                        case '=': {
                            if (key != null) {
                                buffer.append((byte)b);
                                break;
                            }
                            key = buffer.toString();
                            buffer.reset();
                            break;
                        }
                        case '+': {
                            buffer.append((byte)32);
                            break;
                        }
                        case '%': {
                            int dh = in.read();
                            int dl = in.read();
                            if (dh >= 0) {
                                if (dl < 0) break;
                                buffer.append((byte)((TypeUtil.convertHexDigit((byte)((byte)dh)) << 4) + TypeUtil.convertHexDigit((byte)((byte)dl))));
                            }
                            break;
                        }
                        default: {
                            buffer.append((byte)b);
                        }
                    }
                }
                catch (Utf8Appendable.NotUtf8Exception e) {
                    LOG.warn(e.toString(), new Object[0]);
                    LOG.debug((Throwable)e);
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            if (key != null) {
                value = buffer.length() == 0 ? "" : buffer.toString();
                buffer.reset();
                map.add((Object)key, (Object)value);
            } else if (buffer.length() > 0) {
                map.add((Object)buffer.toString(), (Object)"");
            }
        }
    }

    public static void decodeUtf16To(InputStream in, MultiMap map, int maxLength, int maxKeys) throws IOException {
        InputStreamReader input = new InputStreamReader(in, "UTF-16");
        StringWriter buf = new StringWriter(8192);
        IO.copy((Reader)input, (Writer)buf, (long)maxLength);
        UrlEncoded.decodeTo((String)buf.getBuffer().toString(), (MultiMap)map, (String)ENCODING, (int)maxKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(InputStream in, MultiMap map, String charset, int maxLength, int maxKeys) throws IOException {
        if (charset == null) {
            charset = ENCODING;
        }
        if ("UTF-8".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf8To((InputStream)in, (MultiMap)map, (int)maxLength, (int)maxKeys);
            return;
        }
        if ("ISO-8859-1".equals(charset)) {
            UrlEncoded.decode88591To((InputStream)in, (MultiMap)map, (int)maxLength, (int)maxKeys);
            return;
        }
        if ("UTF-16".equalsIgnoreCase(charset)) {
            UrlEncoded.decodeUtf16To((InputStream)in, (MultiMap)map, (int)maxLength, (int)maxKeys);
            return;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            int c;
            String key = null;
            String value = null;
            byte digit = 0;
            int digits = 0;
            int totalLength = 0;
            ByteArrayOutputStream2 output = new ByteArrayOutputStream2();
            int size = 0;
            while ((c = in.read()) > 0) {
                switch ((char)c) {
                    case '&': {
                        size = output.size();
                        value = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        if (key != null) {
                            map.add((Object)key, (Object)value);
                        } else if (value != null && value.length() > 0) {
                            map.add((Object)value, (Object)"");
                        }
                        key = null;
                        value = null;
                        break;
                    }
                    case '=': {
                        if (key != null) {
                            output.write(c);
                            break;
                        }
                        size = output.size();
                        key = size == 0 ? "" : output.toString(charset);
                        output.setCount(0);
                        break;
                    }
                    case '+': {
                        output.write(32);
                        break;
                    }
                    case '%': {
                        digits = 2;
                        break;
                    }
                    default: {
                        if (digits == 2) {
                            digit = TypeUtil.convertHexDigit((byte)((byte)c));
                            digits = 1;
                            break;
                        }
                        if (digits == 1) {
                            output.write((digit << 4) + TypeUtil.convertHexDigit((byte)((byte)c)));
                            digits = 0;
                            break;
                        }
                        output.write(c);
                    }
                }
                if (maxLength < 0 || ++totalLength <= maxLength) continue;
                throw new IllegalStateException("Form too large");
            }
            size = output.size();
            if (key != null) {
                value = size == 0 ? "" : output.toString(charset);
                output.setCount(0);
                map.add((Object)key, (Object)value);
            } else if (size > 0) {
                map.add((Object)output.toString(charset), (Object)"");
            }
        }
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        if (charset == null || StringUtil.isUTF8((String)charset)) {
            Utf8StringBuffer buffer = null;
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i + 1);
                        continue;
                    }
                    buffer.getStringBuffer().append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i);
                    }
                    buffer.getStringBuffer().append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < length) {
                    if (buffer == null) {
                        buffer = new Utf8StringBuffer(length);
                        buffer.getStringBuffer().append(encoded, offset, offset + i);
                    }
                    try {
                        byte b = (byte)TypeUtil.parseInt((String)encoded, (int)(offset + i + 1), (int)2, (int)16);
                        buffer.append(b);
                        i += 2;
                    }
                    catch (NumberFormatException nfe) {
                        buffer.getStringBuffer().append('%');
                    }
                    continue;
                }
                if (buffer == null) continue;
                buffer.getStringBuffer().append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toString();
        }
        StringBuffer buffer = null;
        try {
            for (int i = 0; i < length; ++i) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i + 1);
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (c == '+') {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i);
                    }
                    buffer.append(' ');
                    continue;
                }
                if (c == '%' && i + 2 < length) {
                    if (buffer == null) {
                        buffer = new StringBuffer(length);
                        buffer.append(encoded, offset, offset + i);
                    }
                    byte[] ba = new byte[length];
                    int n = 0;
                    while (c >= '\u0000' && c <= '\u00ff') {
                        if (c == '%') {
                            if (i + 2 < length) {
                                try {
                                    ba[n] = (byte)TypeUtil.parseInt((String)encoded, (int)(offset + i + 1), (int)2, (int)16);
                                    ++n;
                                    i += 3;
                                }
                                catch (NumberFormatException nfe) {
                                    LOG.ignore((Throwable)nfe);
                                    ba[n++] = 37;
                                    ++i;
                                }
                            } else {
                                ba[n++] = 37;
                                ++i;
                            }
                        } else if (c == '+') {
                            ba[n++] = 32;
                            ++i;
                        } else {
                            ba[n++] = (byte)c;
                            ++i;
                        }
                        if (i >= length) break;
                        c = encoded.charAt(offset + i);
                    }
                    --i;
                    buffer.append(new String(ba, 0, n, charset));
                    continue;
                }
                if (buffer == null) continue;
                buffer.append(c);
            }
            if (buffer == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            return buffer.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString((String)string, (String)ENCODING);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        for (int i = 0; i < len; ++i) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
                continue;
            }
            noEncode = false;
            encoded[n++] = 37;
            byte nibble = (byte)((b & 0xF0) >> 4);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            nibble = (byte)(b & 0xF);
            encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return new UrlEncoded(this);
    }
}

