/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.api.FilterRegistration;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterHolder
extends Holder<Filter> {
    private static final Logger LOG = Log.getLogger(FilterHolder.class);
    private transient Filter _filter;
    private transient Config _config;
    private transient FilterRegistration.Dynamic _registration;

    public FilterHolder() {
    }

    public FilterHolder(Class<? extends Filter> filter) {
        this.setHeldClass(filter);
    }

    public FilterHolder(Filter filter) {
        this.setFilter(filter);
    }

    public void doStart() throws Exception {
        super.doStart();
        if (!Filter.class.isAssignableFrom(this._class)) {
            String msg = this._class + " is not a javax.servlet.Filter";
            super.stop();
            throw new IllegalStateException(msg);
        }
        if (this._filter == null) {
            try {
                this._filter = ((ServletContextHandler.Context)this._servletHandler.getServletContext()).createFilter(this.getHeldClass());
            }
            catch (ServletException se) {
                Throwable cause = se.getRootCause();
                if (cause instanceof InstantiationException) {
                    throw (InstantiationException)cause;
                }
                if (cause instanceof IllegalAccessException) {
                    throw (IllegalAccessException)cause;
                }
                throw se;
            }
        }
        this._config = new Config(this);
        this._filter.init((FilterConfig)this._config);
    }

    public void doStop() throws Exception {
        if (this._filter != null) {
            try {
                this.destroyInstance((Object)this._filter);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        if (!this._extInstance) {
            this._filter = null;
        }
        this._config = null;
        super.doStop();
    }

    public void destroyInstance(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Filter f = (Filter)o;
        f.destroy();
        this.getServletHandler().destroyFilter(f);
    }

    public synchronized void setFilter(Filter filter) {
        this._filter = filter;
        this._extInstance = true;
        this.setHeldClass(filter.getClass());
        if (this.getName() == null) {
            this.setName(filter.getClass().getName());
        }
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String toString() {
        return this.getName();
    }

    public FilterRegistration.Dynamic getRegistration() {
        if (this._registration == null) {
            this._registration = new Registration(this);
        }
        return this._registration;
    }
}

