/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.JDBCSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JDBCSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger(JDBCSessionManager.class);
    private ConcurrentHashMap<String, AbstractSession> _sessions;
    protected JDBCSessionIdManager _jdbcSessionIdMgr = null;
    protected long _saveIntervalSec = 60L;

    public void setSaveInterval(long sec) {
        this._saveIntervalSec = sec;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String idInCluster) {
        Session session = (Session)this._sessions.get(idInCluster);
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            try {
                SessionData data = null;
                long now = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    if (session == null) {
                        LOG.debug("getSession(" + idInCluster + "): not in session map," + " now=" + now + " lastSaved=" + (session == null ? 0L : SessionData.access$300((SessionData)Session.access$500((Session)session))) + " interval=" + this._saveIntervalSec * 1000L, new Object[0]);
                    } else {
                        LOG.debug("getSession(" + idInCluster + "): in session map, " + " now=" + now + " lastSaved=" + (session == null ? 0L : SessionData.access$300((SessionData)Session.access$500((Session)session))) + " interval=" + this._saveIntervalSec * 1000L + " lastNode=" + Session.access$500((Session)session).getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName() + " difference=" + (now - SessionData.access$300((SessionData)Session.access$500((Session)session))), new Object[0]);
                    }
                }
                if (session == null || now - SessionData.access$300((SessionData)Session.access$500((Session)session)) >= this._saveIntervalSec * 1000L) {
                    LOG.debug("getSession(" + idInCluster + "): no session in session map or stale session. Reloading session data from db.", new Object[0]);
                    data = this.loadSession(idInCluster, this.canonicalize(this._context.getContextPath()), this.getVirtualHost(this._context));
                } else if (now - SessionData.access$300((SessionData)Session.access$500((Session)session)) >= this._saveIntervalSec * 1000L) {
                    LOG.debug("getSession(" + idInCluster + "): stale session. Reloading session data from db.", new Object[0]);
                    data = this.loadSession(idInCluster, this.canonicalize(this._context.getContextPath()), this.getVirtualHost(this._context));
                } else {
                    LOG.debug("getSession(" + idInCluster + "): session in session map", new Object[0]);
                    data = Session.access$500((Session)session);
                }
                if (data != null) {
                    if (!data.getLastNode().equals(this.getSessionIdManager().getWorkerName()) || session == null) {
                        if (SessionData.access$600((SessionData)data) <= 0L || SessionData.access$600((SessionData)data) > now) {
                            LOG.debug("getSession(" + idInCluster + "): lastNode=" + data.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName(), new Object[0]);
                            data.setLastNode(this.getSessionIdManager().getWorkerName());
                            session = new Session(this, now, data);
                            this._sessions.put(idInCluster, session);
                            session.didActivate();
                            this.updateSessionNode(data);
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession(" + idInCluster + "): Session has expired", new Object[0]);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + idInCluster + "): Session not stale " + Session.access$500((Session)session), new Object[0]);
                    }
                } else {
                    session = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("getSession(" + idInCluster + "): No session in database matching id=" + idInCluster, new Object[0]);
                    }
                }
                return session;
            }
            catch (Exception e) {
                LOG.warn("Unable to load session from database", (Throwable)e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessions() {
        int size = 0;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            size = this._sessions.size();
        }
        return size;
    }

    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this._jdbcSessionIdMgr = (JDBCSessionIdManager)this._sessionIdManager;
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    public void doStop() throws Exception {
        this._sessions.clear();
        this._sessions = null;
        super.doStop();
    }

    protected void invalidateSessions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            session = (Session)this._sessions.get(idInCluster);
        }
        if (session != null) {
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(String idInCluster) {
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            Session session = (Session)this._sessions.remove(idInCluster);
            try {
                if (session != null) {
                    this.deleteSession(Session.access$500((Session)session));
                }
            }
            catch (Exception e) {
                LOG.warn("Problem deleting session id=" + idInCluster, (Throwable)e);
            }
            return session != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            this._sessions.put(session.getClusterId(), session);
        }
        try {
            session.willPassivate();
            this.storeSession(Session.access$500((Session)((Session)session)));
            session.didActivate();
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), (Throwable)e);
        }
    }

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(this, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = false;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            if (this.getSession(session.getClusterId()) != null) {
                removed = true;
                this.removeSession(session.getClusterId());
            }
        }
        if (removed) {
            this._sessionIdManager.removeSession((HttpSession)session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && !this._sessionListeners.isEmpty()) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener l : this._sessionListeners) {
                    l.sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(List<?> sessionIds) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        ListIterator<?> itor = sessionIds.listIterator();
        try {
            try {
                while (itor.hasNext()) {
                    Session session;
                    String sessionId = (String)itor.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Expiring session id " + sessionId, new Object[0]);
                    }
                    if ((session = (Session)this._sessions.get(sessionId)) != null) {
                        session.timeout();
                        itor.remove();
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Unrecognized session id=" + sessionId, new Object[0]);
                }
                Object var8_8 = null;
                thread.setContextClassLoader(old_loader);
            }
            catch (Throwable t) {
                LOG.warn("Problem expiring sessions", t);
                Object var8_9 = null;
                thread.setContextClassLoader(old_loader);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            thread.setContextClassLoader(old_loader);
            throw throwable;
        }
    }

    protected SessionData loadSession(String id, String canonicalContextPath, String vhost) throws Exception {
        AtomicReference _reference = new AtomicReference();
        AtomicReference _exception = new AtomicReference();
        1 load = new /* Unavailable Anonymous Inner Class!! */;
        if (this._context == null) {
            load.run();
        } else {
            this._context.getContextHandler().handle((Runnable)load);
        }
        if (_exception.get() != null) {
            throw (Exception)_exception.get();
        }
        return (SessionData)_reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void storeSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            String rowId = this.calculateRowId(data);
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._insertSession);
            statement.setString(1, rowId);
            statement.setString(2, data.getId());
            statement.setString(3, data.getCanonicalContext());
            statement.setString(4, data.getVirtualHost());
            statement.setString(5, this.getSessionIdManager().getWorkerName());
            statement.setLong(6, data.getAccessed());
            statement.setLong(7, data.getLastAccessed());
            statement.setLong(8, data.getCreated());
            statement.setLong(9, data.getCookieSet());
            statement.setLong(10, now);
            statement.setLong(11, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(12, (InputStream)bais, bytes.length);
            statement.executeUpdate();
            data.setRowId(rowId);
            data.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stored session " + data, new Object[0]);
            }
            Object var12_10 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSession(SessionData data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSession);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(6, (InputStream)bais, bytes.length);
            statement.setString(7, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session " + data, new Object[0]);
            }
            Object var11_9 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateSessionNode(SessionData data) throws Exception {
        String nodeId = this.getSessionIdManager().getWorkerName();
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionNode);
            statement.setString(1, nodeId);
            statement.setString(2, data.getRowId());
            statement.executeUpdate();
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated last node for session id=" + data.getId() + ", lastNode = " + nodeId, new Object[0]);
            }
            Object var6_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSessionAccessTime(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionAccessTime);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessed());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            statement.setString(6, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated access time session id=" + data.getId(), new Object[0]);
            }
            Object var7_5 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void deleteSession(SessionData data) throws Exception {
        Connection connection = this.getConnection();
        PreparedStatement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._deleteSession);
            statement.setString(1, data.getRowId());
            statement.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted Session " + data, new Object[0]);
            }
            Object var5_4 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    private Connection getConnection() throws SQLException {
        return ((JDBCSessionIdManager)this.getSessionIdManager()).getConnection();
    }

    private String calculateRowId(SessionData data) {
        String rowId = this.canonicalize(this._context.getContextPath());
        rowId = rowId + "_" + this.getVirtualHost(this._context);
        rowId = rowId + "_" + data.getId();
        return rowId;
    }

    private String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    static /* synthetic */ String access$000(JDBCSessionManager x0, String x1) {
        return x0.canonicalize(x1);
    }

    static /* synthetic */ String access$100(JDBCSessionManager x0, ContextHandler.Context x1) {
        return x0.getVirtualHost(x1);
    }

    static /* synthetic */ void access$400(JDBCSessionManager x0, SessionData x1) throws Exception {
        x0.updateSessionAccessTime(x1);
    }

    static /* synthetic */ Connection access$700(JDBCSessionManager x0) throws SQLException {
        return x0.getConnection();
    }

    static /* synthetic */ Logger access$800() {
        return LOG;
    }
}

