/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.HostMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ConnectHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ConnectHandler.class);
    private final SelectorManager _selectorManager = new Manager(this, null);
    private volatile int _connectTimeout = 5000;
    private volatile int _writeTimeout = 30000;
    private volatile ThreadPool _threadPool;
    private volatile boolean _privateThreadPool;
    private HostMap<String> _white = new HostMap();
    private HostMap<String> _black = new HostMap();

    public ConnectHandler() {
        this(null);
    }

    public ConnectHandler(String[] white, String[] black) {
        this(null, white, black);
    }

    public ConnectHandler(Handler handler) {
        this.setHandler(handler);
    }

    public ConnectHandler(Handler handler, String[] white, String[] black) {
        this.setHandler(handler);
        this.set(white, this._white);
        this.set(black, this._black);
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this._writeTimeout = writeTimeout;
    }

    public void setServer(Server server) {
        super.setServer(server);
        server.getContainer().update((Object)this, null, (Object)this._selectorManager, "selectManager");
        if (this._privateThreadPool) {
            server.getContainer().update((Object)this, null, (Object)this._privateThreadPool, "threadpool", true);
        } else {
            this._threadPool = server.getThreadPool();
        }
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)(this._privateThreadPool ? this._threadPool : null), (Object)threadPool, "threadpool", true);
        }
        this._privateThreadPool = threadPool != null;
        this._threadPool = threadPool;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this.getServer().getThreadPool();
            this._privateThreadPool = false;
        }
        if (this._threadPool instanceof LifeCycle && !((LifeCycle)this._threadPool).isRunning()) {
            ((LifeCycle)this._threadPool).start();
        }
        this._selectorManager.start();
    }

    protected void doStop() throws Exception {
        this._selectorManager.stop();
        ThreadPool threadPool = this._threadPool;
        if (this._privateThreadPool && this._threadPool != null && threadPool instanceof LifeCycle) {
            ((LifeCycle)threadPool).stop();
        }
        super.doStop();
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            LOG.debug("CONNECT request for {}", new Object[]{request.getRequestURI()});
            try {
                this.handleConnect(baseRequest, request, response, request.getRequestURI());
            }
            catch (Exception e) {
                LOG.warn("ConnectHandler " + baseRequest.getUri() + " " + e, new Object[0]);
                LOG.debug((Throwable)e);
            }
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected void handleConnect(Request baseRequest, HttpServletRequest request, HttpServletResponse response, String serverAddress) throws ServletException, IOException {
        boolean proceed = this.handleAuthentication(request, response, serverAddress);
        if (!proceed) {
            return;
        }
        String host = serverAddress;
        int port = 80;
        int colon = serverAddress.indexOf(58);
        if (colon > 0) {
            host = serverAddress.substring(0, colon);
            port = Integer.parseInt(serverAddress.substring(colon + 1));
        }
        if (!this.validateDestination(host)) {
            LOG.info("ProxyHandler: Forbidden destination " + host, new Object[0]);
            response.setStatus(403);
            baseRequest.setHandled(true);
            return;
        }
        SocketChannel channel = this.connectToServer(request, host, port);
        AbstractHttpConnection httpConnection = AbstractHttpConnection.getCurrentConnection();
        Buffer headerBuffer = ((HttpParser)httpConnection.getParser()).getHeaderBuffer();
        Buffer bodyBuffer = ((HttpParser)httpConnection.getParser()).getBodyBuffer();
        int length = headerBuffer == null ? 0 : headerBuffer.length();
        int n = bodyBuffer == null ? 0 : bodyBuffer.length();
        IndirectNIOBuffer buffer = null;
        if ((length += n) > 0) {
            buffer = new IndirectNIOBuffer(length);
            if (headerBuffer != null) {
                buffer.put(headerBuffer);
                headerBuffer.clear();
            }
            if (bodyBuffer != null) {
                buffer.put(bodyBuffer);
                bodyBuffer.clear();
            }
        }
        ConcurrentHashMap context = new ConcurrentHashMap();
        this.prepareContext(request, context);
        ClientToProxyConnection clientToProxy = this.prepareConnections(context, channel, (Buffer)buffer);
        response.setStatus(200);
        baseRequest.getConnection().getGenerator().setPersistent(true);
        response.getOutputStream().close();
        this.upgradeConnection(request, response, (Connection)clientToProxy);
    }

    private ClientToProxyConnection prepareConnections(ConcurrentMap<String, Object> context, SocketChannel channel, Buffer buffer) {
        AbstractHttpConnection httpConnection = AbstractHttpConnection.getCurrentConnection();
        ProxyToServerConnection proxyToServer = this.newProxyToServerConnection(context, buffer);
        ClientToProxyConnection clientToProxy = this.newClientToProxyConnection(context, channel, httpConnection.getEndPoint(), httpConnection.getTimeStamp());
        clientToProxy.setConnection(proxyToServer);
        proxyToServer.setConnection(clientToProxy);
        return clientToProxy;
    }

    protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) throws ServletException, IOException {
        return true;
    }

    protected ClientToProxyConnection newClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timeStamp) {
        return new ClientToProxyConnection(this, context, channel, endPoint, timeStamp);
    }

    protected ProxyToServerConnection newProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer buffer) {
        return new ProxyToServerConnection(this, context, buffer);
    }

    private SocketChannel connectToServer(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = this.connect(request, host, port);
        channel.configureBlocking(false);
        return channel;
    }

    protected SocketChannel connect(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        try {
            LOG.debug("Establishing connection to {}:{}", new Object[]{host, port});
            channel.socket().setTcpNoDelay(true);
            channel.socket().connect(new InetSocketAddress(host, port), this.getConnectTimeout());
            LOG.debug("Established connection to {}:{}", new Object[]{host, port});
            return channel;
        }
        catch (IOException x) {
            LOG.debug("Failed to establish connection to " + host + ":" + port, (Throwable)x);
            try {
                channel.close();
            }
            catch (IOException xx) {
                LOG.ignore((Throwable)xx);
            }
            throw x;
        }
    }

    protected void prepareContext(HttpServletRequest request, ConcurrentMap<String, Object> context) {
    }

    private void upgradeConnection(HttpServletRequest request, HttpServletResponse response, Connection connection) throws IOException {
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
        response.setStatus(101);
        LOG.debug("Upgraded connection to {}", new Object[]{connection});
    }

    private void register(SocketChannel channel, ProxyToServerConnection proxyToServer) throws IOException {
        this._selectorManager.register(channel, (Object)proxyToServer);
        proxyToServer.waitReady((long)this._connectTimeout);
    }

    protected int read(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        return endPoint.fill(buffer);
    }

    protected int write(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        if (buffer == null) {
            return 0;
        }
        int length = buffer.length();
        StringBuilder debug = LOG.isDebugEnabled() ? new StringBuilder() : null;
        int flushed = endPoint.flush(buffer);
        if (debug != null) {
            debug.append(flushed);
        }
        while (buffer.length() > 0 && !endPoint.isOutputShutdown()) {
            boolean ready;
            if (!endPoint.isBlocking() && !(ready = endPoint.blockWritable((long)this.getWriteTimeout()))) {
                throw new IOException("Write timeout");
            }
            flushed = endPoint.flush(buffer);
            if (debug == null) continue;
            debug.append("+").append(flushed);
        }
        LOG.debug("Written {}/{} bytes {}", new Object[]{debug, length, endPoint});
        buffer.compact();
        return length;
    }

    public void addWhite(String entry) {
        this.add(entry, this._white);
    }

    public void addBlack(String entry) {
        this.add(entry, this._black);
    }

    public void setWhite(String[] entries) {
        this.set(entries, this._white);
    }

    public void setBlack(String[] entries) {
        this.set(entries, this._black);
    }

    protected void set(String[] entries, HostMap<String> hostMap) {
        hostMap.clear();
        if (entries != null && entries.length > 0) {
            for (String addrPath : entries) {
                this.add(addrPath, hostMap);
            }
        }
    }

    private void add(String entry, HostMap<String> hostMap) {
        if (entry != null && entry.length() > 0 && hostMap.get((Object)(entry = entry.trim())) == null) {
            hostMap.put(entry, (Object)entry);
        }
    }

    public boolean validateDestination(String host) {
        Object blackObj;
        Object whiteObj;
        if (this._white.size() > 0 && (whiteObj = this._white.getLazyMatches(host)) == null) {
            return false;
        }
        return this._black.size() <= 0 || (blackObj = this._black.getLazyMatches(host)) == null;
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        if (this._privateThreadPool) {
            ConnectHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this._threadPool, this._selectorManager), TypeUtil.asList((Object[])this.getHandlers()), this.getBeans()});
        } else {
            ConnectHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this._selectorManager), TypeUtil.asList((Object[])this.getHandlers()), this.getBeans()});
        }
    }

    static /* synthetic */ int access$100(ConnectHandler x0) {
        return x0._writeTimeout;
    }

    static /* synthetic */ ThreadPool access$200(ConnectHandler x0) {
        return x0._threadPool;
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }

    static /* synthetic */ void access$500(ConnectHandler x0, SocketChannel x1, ProxyToServerConnection x2) throws IOException {
        x0.register(x1, x2);
    }
}

