/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DigestAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(DigestAuthenticator.class);
    SecureRandom _random = new SecureRandom();
    private long _maxNonceAgeMs = 60000L;
    private ConcurrentMap<String, Nonce> _nonceCount = new ConcurrentHashMap();
    private Queue<Nonce> _nonceQueue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        String mna = configuration.getInitParameter("maxNonceAge");
        if (mna != null) {
            DigestAuthenticator digestAuthenticator = this;
            synchronized (digestAuthenticator) {
                this._maxNonceAgeMs = Long.valueOf(mna);
            }
        }
    }

    public synchronized void setMaxNonceAge(long maxNonceAgeInMillis) {
        this._maxNonceAgeMs = maxNonceAgeInMillis;
    }

    public String getAuthMethod() {
        return "DIGEST";
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return this._deferred;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            boolean stale = false;
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + credentials, new Object[0]);
                }
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
                Digest digest = new Digest(request.getMethod());
                String last = null;
                String name = null;
                block7: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            name = last;
                            last = tok;
                            continue block7;
                        }
                        case ',': {
                            name = null;
                            continue block7;
                        }
                        case ' ': {
                            continue block7;
                        }
                    }
                    last = tok;
                    if (name == null) continue;
                    if ("username".equalsIgnoreCase(name)) {
                        digest.username = tok;
                    } else if ("realm".equalsIgnoreCase(name)) {
                        digest.realm = tok;
                    } else if ("nonce".equalsIgnoreCase(name)) {
                        digest.nonce = tok;
                    } else if ("nc".equalsIgnoreCase(name)) {
                        digest.nc = tok;
                    } else if ("cnonce".equalsIgnoreCase(name)) {
                        digest.cnonce = tok;
                    } else if ("qop".equalsIgnoreCase(name)) {
                        digest.qop = tok;
                    } else if ("uri".equalsIgnoreCase(name)) {
                        digest.uri = tok;
                    } else if ("response".equalsIgnoreCase(name)) {
                        digest.response = tok;
                    }
                    name = null;
                }
                int n = this.checkNonce(digest, (Request)request);
                if (n > 0) {
                    UserIdentity user = this._loginService.login(digest.username, (Object)digest);
                    if (user != null) {
                        this.renewSessionOnAuthentication(request, response);
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                } else if (n == 0) {
                    stale = true;
                }
            }
            if (!DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                String domain = request.getContextPath();
                if (domain == null) {
                    domain = "/";
                }
                response.setHeader("WWW-Authenticate", "Digest realm=\"" + this._loginService.getName() + "\", domain=\"" + domain + "\", nonce=\"" + this.newNonce((Request)request) + "\", algorithm=MD5, qop=\"auth\"," + " stale=" + stale);
                response.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    public String newNonce(Request request) {
        byte[] nounce;
        Nonce nonce;
        do {
            nounce = new byte[24];
            this._random.nextBytes(nounce);
        } while (this._nonceCount.putIfAbsent(nonce._nonce, nonce = new Nonce(new String(B64Code.encode((byte[])nounce)), request.getTimeStamp())) != null);
        this._nonceQueue.add(nonce);
        return nonce._nonce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkNonce(Digest digest, Request request) {
        long expired;
        DigestAuthenticator digestAuthenticator = this;
        synchronized (digestAuthenticator) {
            expired = request.getTimeStamp() - this._maxNonceAgeMs;
        }
        Nonce nonce = (Nonce)this._nonceQueue.peek();
        while (nonce != null && nonce._ts < expired) {
            this._nonceQueue.remove(nonce);
            this._nonceCount.remove(nonce._nonce);
            nonce = (Nonce)this._nonceQueue.peek();
        }
        try {
            nonce = (Nonce)this._nonceCount.get(digest.nonce);
            if (nonce == null) {
                return 0;
            }
            long count = Long.parseLong(digest.nc, 16);
            if (count > Integer.MAX_VALUE) {
                return 0;
            }
            int old = nonce._nc.get();
            while (!nonce._nc.compareAndSet(old, (int)count)) {
                old = nonce._nc.get();
            }
            if (count <= (long)old) {
                return -1;
            }
            return 1;
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            return -1;
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

