/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SslConnection
extends AbstractConnection
implements AsyncConnection {
    private final Logger _logger = Log.getLogger((String)"org.eclipse.jetty.io.nio.ssl");
    private static final NIOBuffer __ZERO_BUFFER = new IndirectNIOBuffer(0);
    private static final ThreadLocal<SslBuffers> __buffers = new ThreadLocal();
    private final SSLEngine _engine;
    private final SSLSession _session;
    private AsyncConnection _connection;
    private final SslEndPoint _sslEndPoint;
    private int _allocations;
    private SslBuffers _buffers;
    private NIOBuffer _inbound;
    private NIOBuffer _unwrapBuf;
    private NIOBuffer _outbound;
    private AsyncEndPoint _aEndp;
    private boolean _allowRenegotiate = true;
    private boolean _handshook;
    private boolean _ishut;
    private boolean _oshut;
    private final AtomicBoolean _progressed = new AtomicBoolean();

    public SslConnection(SSLEngine engine, EndPoint endp) {
        this(engine, endp, System.currentTimeMillis());
    }

    public SslConnection(SSLEngine engine, EndPoint endp, long timeStamp) {
        super(endp, timeStamp);
        this._engine = engine;
        this._session = this._engine.getSession();
        this._aEndp = (AsyncEndPoint)endp;
        this._sslEndPoint = this.newSslEndPoint();
    }

    protected SslEndPoint newSslEndPoint() {
        return new SslEndPoint(this);
    }

    public boolean isAllowRenegotiate() {
        return this._allowRenegotiate;
    }

    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._allowRenegotiate = allowRenegotiate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (this._allocations++ == 0 && this._buffers == null) {
                this._buffers = (SslBuffers)__buffers.get();
                if (this._buffers == null) {
                    this._buffers = new SslBuffers(this._session.getPacketBufferSize() * 2, this._session.getApplicationBufferSize() * 2);
                }
                this._inbound = this._buffers._in;
                this._outbound = this._buffers._out;
                this._unwrapBuf = this._buffers._unwrap;
                __buffers.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBuffers() {
        SslConnection sslConnection = this;
        synchronized (sslConnection) {
            if (--this._allocations == 0 && this._buffers != null && this._inbound.length() == 0 && this._outbound.length() == 0 && this._unwrapBuf.length() == 0) {
                this._inbound = null;
                this._outbound = null;
                this._unwrapBuf = null;
                __buffers.set(this._buffers);
                this._buffers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection handle() throws IOException {
        try {
            this.allocateBuffers();
            boolean progress = true;
            while (progress) {
                AsyncConnection next;
                progress = false;
                if (this._engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    progress = this.process(null, null);
                }
                if ((next = (AsyncConnection)this._connection.handle()) != this._connection && next != null) {
                    this._connection = next;
                    progress = true;
                }
                this._logger.debug("{} handle {} progress={}", new Object[]{this._session, this, progress});
            }
        }
        finally {
            this.releaseBuffers();
            if (!this._ishut && this._sslEndPoint.isInputShutdown() && this._sslEndPoint.isOpen()) {
                this._ishut = true;
                try {
                    this._connection.onInputShutdown();
                }
                catch (Throwable x) {
                    this._logger.warn("onInputShutdown failed", x);
                    try {
                        this._sslEndPoint.close();
                    }
                    catch (IOException e2) {
                        this._logger.ignore((Throwable)e2);
                    }
                }
            }
        }
        return this;
    }

    public boolean isIdle() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void onClose() {
        Connection connection = this._sslEndPoint.getConnection();
        if (connection != null && connection != this) {
            connection.onClose();
        }
    }

    public void onIdleExpired(long idleForMs) {
        try {
            this._logger.debug("onIdleExpired {}ms on {}", new Object[]{idleForMs, this});
            if (this._endp.isOutputShutdown()) {
                this._sslEndPoint.close();
            } else {
                this._sslEndPoint.shutdownOutput();
            }
        }
        catch (IOException e) {
            this._logger.warn((Throwable)e);
            super.onIdleExpired(idleForMs);
        }
    }

    public void onInputShutdown() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean process(Buffer toFill, Buffer toFlush) throws IOException {
        boolean some_progress = false;
        try {
            this.allocateBuffers();
            if (toFill == null) {
                this._unwrapBuf.compact();
                toFill = this._unwrapBuf;
            } else {
                if (toFill.capacity() < this._session.getApplicationBufferSize()) {
                    boolean progress = this.process(null, toFlush);
                    if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                        this._unwrapBuf.skip(toFill.put((Buffer)this._unwrapBuf));
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = progress;
                    return bl;
                }
                if (this._unwrapBuf != null && this._unwrapBuf.hasContent()) {
                    this._unwrapBuf.skip(toFill.put((Buffer)this._unwrapBuf));
                    boolean progress = true;
                    return progress;
                }
            }
            if (toFlush == null) {
                toFlush = __ZERO_BUFFER;
            }
            boolean progress = true;
            while (progress) {
                progress = false;
                int filled = 0;
                int flushed = 0;
                try {
                    if (this._inbound.space() > 0 && (filled = this._endp.fill((Buffer)this._inbound)) > 0) {
                        progress = true;
                    }
                    if (this._outbound.hasContent() && (flushed = this._endp.flush((Buffer)this._outbound)) > 0) {
                        progress = true;
                    }
                }
                catch (IOException e) {
                    try {
                        this._endp.close();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this._logger.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                        throw throwable;
                    }
                }
                this._logger.debug("{} {} {} filled={}/{} flushed={}/{}", new Object[]{this._session, this, this._engine.getHandshakeStatus(), filled, this._inbound.length(), flushed, this._outbound.length()});
                switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this._engine.getHandshakeStatus().ordinal()]) {
                    case 1: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        if (toFill.space() > 0 && this._inbound.hasContent() && this.unwrap(toFill)) {
                            progress = true;
                        }
                        if (!toFlush.hasContent() || this._outbound.space() <= 0 || !this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case 3: {
                        Runnable task;
                        while ((task = this._engine.getDelegatedTask()) != null) {
                            progress = true;
                            task.run();
                        }
                        break;
                    }
                    case 4: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this.wrap(toFlush)) break;
                        progress = true;
                        break;
                    }
                    case 5: {
                        if (this._handshook && !this._allowRenegotiate) {
                            this._endp.close();
                            break;
                        }
                        if (!this._inbound.hasContent() && filled == -1) {
                            this._endp.shutdownInput();
                            break;
                        }
                        if (!this.unwrap(toFill)) break;
                        progress = true;
                    }
                }
                if (this._endp.isOpen() && this._endp.isInputShutdown() && !this._inbound.hasContent()) {
                    this._engine.closeInbound();
                }
                if (this._endp.isOpen() && this._engine.isOutboundDone() && !this._outbound.hasContent()) {
                    this._endp.shutdownOutput();
                }
                some_progress |= progress;
            }
            if (toFill == this._unwrapBuf && this._unwrapBuf.hasContent() && !this._connection.isSuspended()) {
                this._aEndp.dispatch();
            }
        }
        finally {
            this.releaseBuffers();
            if (some_progress) {
                this._progressed.set(true);
            }
        }
        return some_progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean wrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        ByteBuffer bbuf;
        ByteBuffer byteBuffer = bbuf = this.extractByteBuffer(buffer);
        synchronized (byteBuffer) {
            ByteBuffer out_buffer;
            this._outbound.compact();
            ByteBuffer byteBuffer2 = out_buffer = this._outbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    out_buffer.position(this._outbound.putIndex());
                    out_buffer.limit(out_buffer.capacity());
                    result = this._engine.wrap(bbuf, out_buffer);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("{} wrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    buffer.skip(result.bytesConsumed());
                    this._outbound.setPutIndex(this._outbound.putIndex() + result.bytesProduced());
                }
                catch (SSLException e) {
                    this._logger.debug(String.valueOf(this._endp), (Throwable)e);
                    this._endp.close();
                    throw e;
                }
                finally {
                    out_buffer.position(0);
                    out_buffer.limit(out_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[result.getStatus().ordinal()]) {
            case 1: {
                throw new IllegalStateException();
            }
            case 2: {
                break;
            }
            case 3: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case 4: {
                this._logger.debug("wrap CLOSE {} {}", new Object[]{this, result});
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                this._logger.debug("{} wrap default {}", new Object[]{this._session, result});
                throw new IOException(result.toString());
            }
        }
        return result.bytesConsumed() > 0 || result.bytesProduced() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean unwrap(Buffer buffer) throws IOException {
        SSLEngineResult result;
        ByteBuffer bbuf;
        if (!this._inbound.hasContent()) {
            return false;
        }
        ByteBuffer byteBuffer = bbuf = this.extractByteBuffer(buffer);
        synchronized (byteBuffer) {
            ByteBuffer in_buffer;
            ByteBuffer byteBuffer2 = in_buffer = this._inbound.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    bbuf.position(buffer.putIndex());
                    bbuf.limit(buffer.capacity());
                    in_buffer.position(this._inbound.getIndex());
                    in_buffer.limit(this._inbound.putIndex());
                    result = this._engine.unwrap(in_buffer, bbuf);
                    if (this._logger.isDebugEnabled()) {
                        this._logger.debug("{} unwrap {} {} consumed={} produced={}", new Object[]{this._session, result.getStatus(), result.getHandshakeStatus(), result.bytesConsumed(), result.bytesProduced()});
                    }
                    this._inbound.skip(result.bytesConsumed());
                    this._inbound.compact();
                    buffer.setPutIndex(buffer.putIndex() + result.bytesProduced());
                }
                catch (SSLException e) {
                    this._logger.debug(String.valueOf(this._endp), (Throwable)e);
                    this._endp.close();
                    throw e;
                }
                finally {
                    in_buffer.position(0);
                    in_buffer.limit(in_buffer.capacity());
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        switch (1.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[result.getStatus().ordinal()]) {
            case 1: {
                if (!this._endp.isInputShutdown()) break;
                this._inbound.clear();
                break;
            }
            case 2: {
                if (!this._logger.isDebugEnabled()) break;
                this._logger.debug("{} unwrap {} {}->{}", new Object[]{this._session, result.getStatus(), this._inbound.toDetailString(), buffer.toDetailString()});
                break;
            }
            case 3: {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._handshook = true;
                break;
            }
            case 4: {
                this._logger.debug("unwrap CLOSE {} {}", new Object[]{this, result});
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) break;
                this._endp.close();
                break;
            }
            default: {
                this._logger.debug("{} wrap default {}", new Object[]{this._session, result});
                throw new IOException(result.toString());
            }
        }
        return result.bytesConsumed() > 0 || result.bytesProduced() > 0;
    }

    private ByteBuffer extractByteBuffer(Buffer buffer) {
        if (buffer.buffer() instanceof NIOBuffer) {
            return ((NIOBuffer)buffer.buffer()).getByteBuffer();
        }
        return ByteBuffer.wrap(buffer.array());
    }

    public AsyncEndPoint getSslEndPoint() {
        return this._sslEndPoint;
    }

    public String toString() {
        return String.format("%s %s", super.toString(), this._sslEndPoint);
    }

    static /* synthetic */ SSLEngine access$000(SslConnection x0) {
        return x0._engine;
    }

    static /* synthetic */ AsyncEndPoint access$100(SslConnection x0) {
        return x0._aEndp;
    }

    static /* synthetic */ SSLSession access$200(SslConnection x0) {
        return x0._session;
    }

    static /* synthetic */ Logger access$300(SslConnection x0) {
        return x0._logger;
    }

    static /* synthetic */ boolean access$402(SslConnection x0, boolean x1) {
        x0._oshut = x1;
        return x0._oshut;
    }

    static /* synthetic */ boolean access$400(SslConnection x0) {
        return x0._oshut;
    }

    static /* synthetic */ EndPoint access$500(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ NIOBuffer access$600(SslConnection x0) {
        return x0._unwrapBuf;
    }

    static /* synthetic */ NIOBuffer access$700(SslConnection x0) {
        return x0._inbound;
    }

    static /* synthetic */ EndPoint access$800(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ boolean access$900(SslConnection x0, Buffer x1, Buffer x2) throws IOException {
        return x0.process(x1, x2);
    }

    static /* synthetic */ EndPoint access$1000(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ EndPoint access$1100(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ EndPoint access$1200(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ EndPoint access$1300(SslConnection x0) {
        return x0._endp;
    }

    static /* synthetic */ AtomicBoolean access$1400(SslConnection x0) {
        return x0._progressed;
    }

    static /* synthetic */ AsyncConnection access$1500(SslConnection x0) {
        return x0._connection;
    }

    static /* synthetic */ AsyncConnection access$1502(SslConnection x0, AsyncConnection x1) {
        x0._connection = x1;
        return x0._connection;
    }

    static /* synthetic */ NIOBuffer access$1600(SslConnection x0) {
        return x0._outbound;
    }

    static /* synthetic */ boolean access$1700(SslConnection x0) {
        return x0._ishut;
    }
}

