/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.AbstractBuffers;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ThreadLocalBuffers;

public class ThreadLocalBuffers
extends AbstractBuffers {
    private final ThreadLocal<ThreadBuffers> _buffers = new /* Unavailable Anonymous Inner Class!! */;

    public ThreadLocalBuffers(Buffers.Type headerType, int headerSize, Buffers.Type bufferType, int bufferSize, Buffers.Type otherType) {
        super(headerType, headerSize, bufferType, bufferSize, otherType);
    }

    public Buffer getBuffer() {
        ThreadBuffers buffers = (ThreadBuffers)this._buffers.get();
        if (buffers._buffer != null) {
            Buffer b = buffers._buffer;
            buffers._buffer = null;
            return b;
        }
        if (buffers._other != null && this.isBuffer(buffers._other)) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newBuffer();
    }

    public Buffer getHeader() {
        ThreadBuffers buffers = (ThreadBuffers)this._buffers.get();
        if (buffers._header != null) {
            Buffer b = buffers._header;
            buffers._header = null;
            return b;
        }
        if (buffers._other != null && this.isHeader(buffers._other)) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newHeader();
    }

    public Buffer getBuffer(int size) {
        ThreadBuffers buffers = (ThreadBuffers)this._buffers.get();
        if (buffers._other != null && buffers._other.capacity() == size) {
            Buffer b = buffers._other;
            buffers._other = null;
            return b;
        }
        return this.newBuffer(size);
    }

    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (buffer.isVolatile() || buffer.isImmutable()) {
            return;
        }
        ThreadBuffers buffers = (ThreadBuffers)this._buffers.get();
        if (buffers._header == null && this.isHeader(buffer)) {
            buffers._header = buffer;
        } else if (buffers._buffer == null && this.isBuffer(buffer)) {
            buffers._buffer = buffer;
        } else {
            buffers._other = buffer;
        }
    }

    public String toString() {
        return "{{" + this.getHeaderSize() + "," + this.getBufferSize() + "}}";
    }
}

