/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.AbstractBuffers;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;

public abstract class AbstractBuffers
implements Buffers {
    protected final Buffers.Type _headerType;
    protected final int _headerSize;
    protected final Buffers.Type _bufferType;
    protected final int _bufferSize;
    protected final Buffers.Type _otherType;

    public AbstractBuffers(Buffers.Type headerType, int headerSize, Buffers.Type bufferType, int bufferSize, Buffers.Type otherType) {
        this._headerType = headerType;
        this._headerSize = headerSize;
        this._bufferType = bufferType;
        this._bufferSize = bufferSize;
        this._otherType = otherType;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getHeaderSize() {
        return this._headerSize;
    }

    protected final Buffer newHeader() {
        switch (1.$SwitchMap$org$eclipse$jetty$io$Buffers$Type[this._headerType.ordinal()]) {
            case 1: {
                return new ByteArrayBuffer(this._headerSize);
            }
            case 2: {
                return new DirectNIOBuffer(this._headerSize);
            }
            case 3: {
                return new IndirectNIOBuffer(this._headerSize);
            }
        }
        throw new IllegalStateException();
    }

    protected final Buffer newBuffer() {
        switch (1.$SwitchMap$org$eclipse$jetty$io$Buffers$Type[this._bufferType.ordinal()]) {
            case 1: {
                return new ByteArrayBuffer(this._bufferSize);
            }
            case 2: {
                return new DirectNIOBuffer(this._bufferSize);
            }
            case 3: {
                return new IndirectNIOBuffer(this._bufferSize);
            }
        }
        throw new IllegalStateException();
    }

    protected final Buffer newBuffer(int size) {
        switch (1.$SwitchMap$org$eclipse$jetty$io$Buffers$Type[this._otherType.ordinal()]) {
            case 1: {
                return new ByteArrayBuffer(size);
            }
            case 2: {
                return new DirectNIOBuffer(size);
            }
            case 3: {
                return new IndirectNIOBuffer(size);
            }
        }
        throw new IllegalStateException();
    }

    public final boolean isHeader(Buffer buffer) {
        if (buffer.capacity() == this._headerSize) {
            switch (1.$SwitchMap$org$eclipse$jetty$io$Buffers$Type[this._headerType.ordinal()]) {
                case 1: {
                    return buffer instanceof ByteArrayBuffer && !(buffer instanceof IndirectNIOBuffer);
                }
                case 2: {
                    return buffer instanceof DirectNIOBuffer;
                }
                case 3: {
                    return buffer instanceof IndirectNIOBuffer;
                }
            }
        }
        return false;
    }

    public final boolean isBuffer(Buffer buffer) {
        if (buffer.capacity() == this._bufferSize) {
            switch (1.$SwitchMap$org$eclipse$jetty$io$Buffers$Type[this._bufferType.ordinal()]) {
                case 1: {
                    return buffer instanceof ByteArrayBuffer && !(buffer instanceof IndirectNIOBuffer);
                }
                case 2: {
                    return buffer instanceof DirectNIOBuffer;
                }
                case 3: {
                    return buffer instanceof IndirectNIOBuffer;
                }
            }
        }
        return false;
    }

    public String toString() {
        return String.format("%s [%d,%d]", this.getClass().getSimpleName(), this._headerSize, this._bufferSize);
    }
}

