/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import org.codehaus.jackson.map.util.PrimitiveArrayBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PrimitiveArrayBuilder<T> {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    T _freeBuffer;
    Node<T> _bufferHead;
    Node<T> _bufferTail;
    int _bufferedEntryCount;

    protected PrimitiveArrayBuilder() {
    }

    public T resetAndStart() {
        this._reset();
        return (T)(this._freeBuffer == null ? this._constructArray(12) : this._freeBuffer);
    }

    public final T appendCompletedChunk(T fullChunk, int fullChunkLength) {
        Node next = new Node(fullChunk, fullChunkLength);
        if (this._bufferHead == null) {
            this._bufferHead = this._bufferTail = next;
        } else {
            this._bufferTail.linkNext(next);
            this._bufferTail = next;
        }
        this._bufferedEntryCount += fullChunkLength;
        int nextLen = fullChunkLength;
        nextLen = nextLen < 16384 ? (nextLen += nextLen) : (nextLen += nextLen >> 2);
        return (T)this._constructArray(nextLen);
    }

    public T completeAndClearBuffer(T lastChunk, int lastChunkEntries) {
        int totalSize = lastChunkEntries + this._bufferedEntryCount;
        Object resultArray = this._constructArray(totalSize);
        int ptr = 0;
        for (Node n = this._bufferHead; n != null; n = n.next()) {
            ptr = n.copyData(resultArray, ptr);
        }
        System.arraycopy(lastChunk, 0, resultArray, ptr, lastChunkEntries);
        if ((ptr += lastChunkEntries) != totalSize) {
            throw new IllegalStateException("Should have gotten " + totalSize + " entries, got " + ptr);
        }
        return (T)resultArray;
    }

    protected abstract T _constructArray(int var1);

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }
}

