/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class ClassUtil {
    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore) {
        return ClassUtil.findSuperTypes(cls, endBefore, new ArrayList(8));
    }

    public static List<Class<?>> findSuperTypes(Class<?> cls, Class<?> endBefore, List<Class<?>> result) {
        ClassUtil._addSuperTypes(cls, endBefore, result, (boolean)false);
        return result;
    }

    private static void _addSuperTypes(Class<?> cls, Class<?> endBefore, Collection<Class<?>> result, boolean addClassItself) {
        if (cls == endBefore || cls == null || cls == Object.class) {
            return;
        }
        if (addClassItself) {
            if (result.contains(cls)) {
                return;
            }
            result.add(cls);
        }
        for (Class<?> intCls : cls.getInterfaces()) {
            ClassUtil._addSuperTypes(intCls, endBefore, result, (boolean)true);
        }
        ClassUtil._addSuperTypes(cls.getSuperclass(), endBefore, result, (boolean)true);
    }

    public static String canBeABeanType(Class<?> type) {
        if (type.isAnnotation()) {
            return "annotation";
        }
        if (type.isArray()) {
            return "array";
        }
        if (type.isEnum()) {
            return "enum";
        }
        if (type.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    @Deprecated
    public static String isLocalType(Class<?> type) {
        return ClassUtil.isLocalType(type, (boolean)false);
    }

    public static String isLocalType(Class<?> type, boolean allowNonStatic) {
        try {
            if (type.getEnclosingMethod() != null) {
                return "local/anonymous";
            }
            if (!allowNonStatic && type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
                return "non-static member class";
            }
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static Class<?> getOuterClass(Class<?> type) {
        try {
            if (type.getEnclosingMethod() != null) {
                return null;
            }
            if (!Modifier.isStatic(type.getModifiers())) {
                return type.getEnclosingClass();
            }
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isProxyType(Class<?> type) {
        if (Proxy.isProxyClass(type)) {
            return true;
        }
        String name = type.getName();
        return name.startsWith("net.sf.cglib.proxy.") || name.startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> type) {
        int mod = type.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int mod = member.getModifiers();
        return (mod & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> type) {
        if (type.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type)) {
            return true;
        }
        return Map.class.isAssignableFrom(type);
    }

    public static String getClassDescription(Object classOrInstance) {
        if (classOrInstance == null) {
            return "unknown";
        }
        Class<?> cls = classOrInstance instanceof Class ? (Class<?>)classOrInstance : classOrInstance.getClass();
        return cls.getName();
    }

    public static boolean hasGetterSignature(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        if (pts != null && pts.length != 0) {
            return false;
        }
        return Void.TYPE != m.getReturnType();
    }

    public static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static void throwRootCause(Throwable t) throws Exception {
        if ((t = ClassUtil.getRootCause((Throwable)t)) instanceof Exception) {
            throw (Exception)t;
        }
        throw (Error)t;
    }

    public static void throwAsIAE(Throwable t) {
        ClassUtil.throwAsIAE((Throwable)t, (String)t.getMessage());
    }

    public static void throwAsIAE(Throwable t, String msg) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalArgumentException(msg, t);
    }

    public static void unwrapAndThrowAsIAE(Throwable t) {
        ClassUtil.throwAsIAE((Throwable)ClassUtil.getRootCause((Throwable)t));
    }

    public static void unwrapAndThrowAsIAE(Throwable t, String msg) {
        ClassUtil.throwAsIAE((Throwable)ClassUtil.getRootCause((Throwable)t), (String)msg);
    }

    public static <T> T createInstance(Class<T> cls, boolean canFixAccess) throws IllegalArgumentException {
        Constructor ctor = ClassUtil.findConstructor(cls, (boolean)canFixAccess);
        if (ctor == null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " has no default (no arg) constructor");
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to instantiate class " + cls.getName() + ", problem: " + e.getMessage()));
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> cls, boolean canFixAccess) throws IllegalArgumentException {
        try {
            Constructor<T> ctor = cls.getDeclaredConstructor(new Class[0]);
            if (canFixAccess) {
                ClassUtil.checkAndFixAccess(ctor);
            } else if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + cls.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
            }
            return ctor;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            ClassUtil.unwrapAndThrowAsIAE((Throwable)e, (String)("Failed to find default constructor of class " + cls.getName() + ", problem: " + e.getMessage()));
        }
        return null;
    }

    public static Object defaultValue(Class<?> cls) {
        if (cls == Integer.TYPE) {
            return 0;
        }
        if (cls == Long.TYPE) {
            return 0L;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (cls == Double.TYPE) {
            return 0.0;
        }
        if (cls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (cls == Byte.TYPE) {
            return (byte)0;
        }
        if (cls == Short.TYPE) {
            return (short)0;
        }
        if (cls == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + cls.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + primitiveType.getName() + " is not a primitive type");
    }

    public static void checkAndFixAccess(Member member) {
        block2: {
            AccessibleObject ao = (AccessibleObject)((Object)member);
            try {
                ao.setAccessible(true);
            }
            catch (SecurityException se) {
                if (ao.isAccessible()) break block2;
                Class<?> declClass = member.getDeclaringClass();
                throw new IllegalArgumentException("Can not access " + member + " (from class " + declClass.getName() + "; failed to set access: " + se.getMessage());
            }
        }
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> s) {
        if (!s.isEmpty()) {
            return ClassUtil.findEnumType((Enum)((Enum)s.iterator().next()));
        }
        return EnumTypeLocator.instance.enumTypeFor(s);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> m) {
        if (!m.isEmpty()) {
            return ClassUtil.findEnumType((Enum)((Enum)m.keySet().iterator().next()));
        }
        return EnumTypeLocator.instance.enumTypeFor(m);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> en) {
        Class<?> ec = en.getClass();
        if (ec.getSuperclass() != Enum.class) {
            ec = ec.getSuperclass();
        }
        return ec;
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> cls) {
        if (cls.getSuperclass() != Enum.class) {
            cls = cls.getSuperclass();
        }
        return cls;
    }
}

