/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser.std;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.std.StdKeyDeserializer;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.map.util.EnumResolver;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdKeyDeserializers {
    protected final HashMap<JavaType, KeyDeserializer> _keyDeserializers = new HashMap();

    protected StdKeyDeserializers() {
        this.add((StdKeyDeserializer)new StdKeyDeserializer.BoolKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.ByteKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.CharKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.ShortKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.IntKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.LongKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.FloatKD());
        this.add((StdKeyDeserializer)new StdKeyDeserializer.DoubleKD());
    }

    private void add(StdKeyDeserializer kdeser) {
        Class keyClass = kdeser.getKeyClass();
        this._keyDeserializers.put(TypeFactory.defaultInstance().constructType((Type)keyClass), kdeser);
    }

    public static HashMap<JavaType, KeyDeserializer> constructAll() {
        return new StdKeyDeserializers()._keyDeserializers;
    }

    public static KeyDeserializer constructEnumKeyDeserializer(DeserializationConfig config, JavaType type) {
        EnumResolver er = EnumResolver.constructUnsafe((Class)type.getRawClass(), (AnnotationIntrospector)config.getAnnotationIntrospector());
        return new StdKeyDeserializer.EnumKD(er);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type) {
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        Constructor ctor = beanDesc.findSingleArgConstructor(new Class[]{String.class});
        if (ctor != null) {
            if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                ClassUtil.checkAndFixAccess((Member)ctor);
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = beanDesc.findFactoryMethod(new Class[]{String.class});
        if (m != null) {
            if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                ClassUtil.checkAndFixAccess((Member)m);
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }
}

