/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.std.BaseNodeDeserializer;
import org.codehaus.jackson.map.deser.std.StdDeserializer;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseNodeDeserializer<N extends JsonNode>
extends StdDeserializer<N> {
    public BaseNodeDeserializer(Class<N> nodeClass) {
        super(nodeClass);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    protected void _reportProblem(JsonParser jp, String msg) throws JsonMappingException {
        throw new JsonMappingException(msg, jp.getTokenLocation());
    }

    protected void _handleDuplicateField(String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
    }

    protected final ObjectNode deserializeObject(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException, JsonProcessingException {
        ObjectNode node = nodeFactory.objectNode();
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            TextNode value;
            String fieldName = jp.getCurrentName();
            switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[jp.nextToken().ordinal()]) {
                case 1: {
                    value = this.deserializeObject(jp, ctxt, nodeFactory);
                    break;
                }
                case 2: {
                    value = this.deserializeArray(jp, ctxt, nodeFactory);
                    break;
                }
                case 3: {
                    value = nodeFactory.textNode(jp.getText());
                    break;
                }
                default: {
                    value = this.deserializeAny(jp, ctxt, nodeFactory);
                }
            }
            JsonNode old = node.put(fieldName, (JsonNode)value);
            if (old != null) {
                this._handleDuplicateField(fieldName, node, old, (JsonNode)value);
            }
            t = jp.nextToken();
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException, JsonProcessingException {
        ArrayNode node = nodeFactory.arrayNode();
        block6: while (true) {
            switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[jp.nextToken().ordinal()]) {
                case 1: {
                    node.add((JsonNode)this.deserializeObject(jp, ctxt, nodeFactory));
                    continue block6;
                }
                case 2: {
                    node.add((JsonNode)this.deserializeArray(jp, ctxt, nodeFactory));
                    continue block6;
                }
                case 4: {
                    return node;
                }
                case 3: {
                    node.add((JsonNode)nodeFactory.textNode(jp.getText()));
                    continue block6;
                }
            }
            node.add(this.deserializeAny(jp, ctxt, nodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser jp, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException, JsonProcessingException {
        switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[jp.getCurrentToken().ordinal()]) {
            case 1: {
                return this.deserializeObject(jp, ctxt, nodeFactory);
            }
            case 2: {
                return this.deserializeArray(jp, ctxt, nodeFactory);
            }
            case 5: {
                return this.deserializeObject(jp, ctxt, nodeFactory);
            }
            case 6: {
                return nodeFactory.POJONode(jp.getEmbeddedObject());
            }
            case 3: {
                return nodeFactory.textNode(jp.getText());
            }
            case 7: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_INTEGER || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_INTEGER_FOR_INTS)) {
                    return nodeFactory.numberNode(jp.getBigIntegerValue());
                }
                if (nt == JsonParser.NumberType.INT) {
                    return nodeFactory.numberNode(jp.getIntValue());
                }
                return nodeFactory.numberNode(jp.getLongValue());
            }
            case 8: {
                JsonParser.NumberType nt = jp.getNumberType();
                if (nt == JsonParser.NumberType.BIG_DECIMAL || ctxt.isEnabled(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return nodeFactory.numberNode(jp.getDecimalValue());
                }
                return nodeFactory.numberNode(jp.getDoubleValue());
            }
            case 9: {
                return nodeFactory.booleanNode(true);
            }
            case 10: {
                return nodeFactory.booleanNode(false);
            }
            case 11: {
                return nodeFactory.nullNode();
            }
        }
        throw ctxt.mappingException(this.getValueClass());
    }
}

