/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Member;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.AbstractTypeResolver;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.BeanPropertyDefinition;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.KeyDeserializers;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.AbstractDeserializer;
import org.codehaus.jackson.map.deser.BasicDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.deser.BeanDeserializerModifier;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.deser.ValueInstantiator;
import org.codehaus.jackson.map.deser.ValueInstantiators;
import org.codehaus.jackson.map.deser.impl.CreatorCollector;
import org.codehaus.jackson.map.deser.impl.CreatorProperty;
import org.codehaus.jackson.map.deser.std.ThrowableDeserializer;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.AnnotatedWithParams;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionLikeType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapLikeType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeserializerFactory
extends BasicDeserializerFactory {
    private static final Class<?>[] INIT_CAUSE_PARAMS = new Class[]{Throwable.class};
    public static final BeanDeserializerFactory instance = new BeanDeserializerFactory(null);
    protected final DeserializerFactory.Config _factoryConfig;

    @Deprecated
    public BeanDeserializerFactory() {
        this(null);
    }

    public BeanDeserializerFactory(DeserializerFactory.Config config) {
        if (config == null) {
            config = new ConfigImpl();
        }
        this._factoryConfig = config;
    }

    public final DeserializerFactory.Config getConfig() {
        return this._factoryConfig;
    }

    public DeserializerFactory withConfig(DeserializerFactory.Config config) {
        if (this._factoryConfig == config) {
            return this;
        }
        if (this.getClass() != BeanDeserializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanDeserializerFactory (" + this.getClass().getName() + ") has not properly overridden method 'withAdditionalDeserializers': can not instantiate subtype with " + "additional deserializer definitions");
        }
        return new BeanDeserializerFactory(config);
    }

    public KeyDeserializer createKeyDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        if (this._factoryConfig.hasKeyDeserializers()) {
            BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(type.getRawClass());
            for (KeyDeserializers d : this._factoryConfig.keyDeserializers()) {
                KeyDeserializer deser = d.findKeyDeserializer(type, config, (BeanDescription)beanDesc, property);
                if (deser == null) continue;
                return deser;
            }
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType type, DeserializationConfig config, DeserializerProvider provider, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findArrayDeserializer(type, config, provider, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType type, DeserializationConfig config, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findCollectionDeserializer(type, config, provider, (BeanDescription)beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType type, DeserializationConfig config, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findCollectionLikeDeserializer(type, config, provider, (BeanDescription)beanDesc, property, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> type, DeserializationConfig config, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findEnumDeserializer(type, config, (BeanDescription)beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType type, DeserializationConfig config, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findMapDeserializer(type, config, provider, (BeanDescription)beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType type, DeserializationConfig config, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findMapLikeDeserializer(type, config, provider, (BeanDescription)beanDesc, property, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> type, DeserializationConfig config, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findTreeNodeDeserializer(type, config, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType type, DeserializationConfig config, DeserializerProvider provider, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        for (Deserializers d : this._factoryConfig.deserializers()) {
            JsonDeserializer deser = d.findBeanDeserializer(type, config, provider, (BeanDescription)beanDesc, property);
            if (deser == null) continue;
            return deser;
        }
        return null;
    }

    public JavaType mapAbstractType(DeserializationConfig config, JavaType type) throws JsonMappingException {
        JavaType next;
        while ((next = this._mapAbstractType2(config, type)) != null) {
            Class nextCls;
            Class prevCls = type.getRawClass();
            if (prevCls == (nextCls = next.getRawClass()) || !prevCls.isAssignableFrom(nextCls)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + type + " to " + next + ": latter is not a subtype of former");
            }
            type = next;
        }
        return type;
    }

    public ValueInstantiator findValueInstantiator(DeserializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        ValueInstantiator instantiator;
        AnnotatedClass ac = beanDesc.getClassInfo();
        Object instDef = config.getAnnotationIntrospector().findValueInstantiator(ac);
        if (instDef != null) {
            if (instDef instanceof ValueInstantiator) {
                instantiator = (ValueInstantiator)instDef;
            } else {
                if (!(instDef instanceof Class)) {
                    throw new IllegalStateException("Invalid value instantiator returned for type " + beanDesc + ": neither a Class nor ValueInstantiator");
                }
                Class cls = (Class)instDef;
                if (!ValueInstantiator.class.isAssignableFrom(cls)) {
                    throw new IllegalStateException("Invalid instantiator Class<?> returned for type " + beanDesc + ": " + cls.getName() + " not a ValueInstantiator");
                }
                Class instClass = cls;
                instantiator = config.valueInstantiatorInstance((Annotated)ac, instClass);
            }
        } else {
            instantiator = this.constructDefaultValueInstantiator(config, beanDesc);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators insts : this._factoryConfig.valueInstantiators()) {
                instantiator = insts.findValueInstantiator(config, (BeanDescription)beanDesc, instantiator);
                if (instantiator != null) continue;
                throw new JsonMappingException("Broken registered ValueInstantiators (of type " + insts.getClass().getName() + "): returned null ValueInstantiator");
            }
        }
        return instantiator;
    }

    public JsonDeserializer<Object> createBeanDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JavaType concreteType;
        JsonDeserializer custom;
        BasicBeanDescription beanDesc;
        JsonDeserializer ad;
        if (type.isAbstract()) {
            type = this.mapAbstractType(config, type);
        }
        if ((ad = this.findDeserializerFromAnnotation(config, (Annotated)(beanDesc = (BasicBeanDescription)config.introspect(type)).getClassInfo(), property)) != null) {
            return ad;
        }
        JavaType newType = this.modifyTypeByAnnotation(config, (Annotated)beanDesc.getClassInfo(), type, null);
        if (newType.getRawClass() != type.getRawClass()) {
            type = newType;
            beanDesc = (BasicBeanDescription)config.introspect(type);
        }
        if ((custom = this._findCustomBeanDeserializer(type, config, p, beanDesc, property)) != null) {
            return custom;
        }
        if (type.isThrowable()) {
            return this.buildThrowableDeserializer(config, type, beanDesc, property);
        }
        if (type.isAbstract() && (concreteType = this.materializeAbstractType(config, beanDesc)) != null) {
            beanDesc = (BasicBeanDescription)config.introspect(concreteType);
            return this.buildBeanDeserializer(config, concreteType, beanDesc, property);
        }
        JsonDeserializer deser = this.findStdBeanDeserializer(config, p, type, property);
        if (deser != null) {
            return deser;
        }
        if (!this.isPotentialBeanType(type.getRawClass())) {
            return null;
        }
        return this.buildBeanDeserializer(config, type, beanDesc, property);
    }

    protected JavaType _mapAbstractType2(DeserializationConfig config, JavaType type) throws JsonMappingException {
        Class currClass = type.getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver resolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType concrete = resolver.findTypeMapping(config, type);
                if (concrete == null || concrete.getRawClass() == currClass) continue;
                return concrete;
            }
        }
        return null;
    }

    protected JavaType materializeAbstractType(DeserializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        JavaType abstractType = beanDesc.getType();
        for (AbstractTypeResolver r : this._factoryConfig.abstractTypeResolvers()) {
            JavaType concrete = r.resolveAbstractType(config, abstractType);
            if (concrete == null) continue;
            return concrete;
        }
        return null;
    }

    public JsonDeserializer<Object> buildBeanDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        ValueInstantiator valueInstantiator = this.findValueInstantiator(config, beanDesc);
        if (type.isAbstract() && !valueInstantiator.canInstantiate()) {
            return new AbstractDeserializer(type);
        }
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setValueInstantiator(valueInstantiator);
        this.addBeanProps(config, beanDesc, builder);
        this.addReferenceProperties(config, beanDesc, builder);
        this.addInjectables(config, beanDesc, builder);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, beanDesc, builder);
            }
        }
        JsonDeserializer deserializer = builder.build(property);
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    public JsonDeserializer<Object> buildThrowableDeserializer(DeserializationConfig config, JavaType type, BasicBeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
        JsonDeserializer deserializer;
        SettableBeanProperty prop;
        BeanDeserializerBuilder builder = this.constructBeanDeserializerBuilder(beanDesc);
        builder.setValueInstantiator(this.findValueInstantiator(config, beanDesc));
        this.addBeanProps(config, beanDesc, builder);
        AnnotatedMethod am = beanDesc.findMethod("initCause", INIT_CAUSE_PARAMS);
        if (am != null && (prop = this.constructSettableProperty(config, beanDesc, "cause", am)) != null) {
            builder.addOrReplaceProperty(prop, true);
        }
        builder.addIgnorable("localizedMessage");
        builder.addIgnorable("message");
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                builder = mod.updateBuilder(config, beanDesc, builder);
            }
        }
        if ((deserializer = builder.build(property)) instanceof BeanDeserializer) {
            deserializer = new ThrowableDeserializer((BeanDeserializer)deserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier mod : this._factoryConfig.deserializerModifiers()) {
                deserializer = mod.modifyDeserializer(config, beanDesc, deserializer);
            }
        }
        return deserializer;
    }

    protected BeanDeserializerBuilder constructBeanDeserializerBuilder(BasicBeanDescription beanDesc) {
        return new BeanDeserializerBuilder(beanDesc);
    }

    protected ValueInstantiator constructDefaultValueInstantiator(DeserializationConfig config, BasicBeanDescription beanDesc) throws JsonMappingException {
        AnnotatedConstructor defaultCtor;
        boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        CreatorCollector creators = new CreatorCollector(beanDesc, fixAccess);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        if (beanDesc.getType().isConcrete() && (defaultCtor = beanDesc.findDefaultConstructor()) != null) {
            if (fixAccess) {
                ClassUtil.checkAndFixAccess((Member)defaultCtor.getAnnotated());
            }
            creators.setDefaultConstructor(defaultCtor);
        }
        VisibilityChecker vchecker = config.getDefaultVisibilityChecker();
        vchecker = config.getAnnotationIntrospector().findAutoDetectVisibility(beanDesc.getClassInfo(), vchecker);
        this._addDeserializerFactoryMethods(config, beanDesc, vchecker, intr, creators);
        this._addDeserializerConstructors(config, beanDesc, vchecker, intr, creators);
        return creators.constructValueInstantiator(config);
    }

    protected void _addDeserializerConstructors(DeserializationConfig config, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        for (AnnotatedConstructor ctor : beanDesc.getConstructors()) {
            int argCount = ctor.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation((Annotated)ctor);
            boolean isVisible = vchecker.isCreatorVisible((AnnotatedMember)ctor);
            if (argCount == 1) {
                AnnotatedParameter param = ctor.getParameter(0);
                String name = intr.findPropertyNameForParam(param);
                Object injectId = intr.findInjectableValueId((AnnotatedMember)param);
                if (injectId != null || name != null && name.length() > 0) {
                    CreatorProperty[] properties = new CreatorProperty[]{this.constructCreatorProperty(config, beanDesc, name, 0, param, injectId)};
                    creators.addPropertyCreator((AnnotatedWithParams)ctor, properties);
                    continue;
                }
                Class type = ctor.getParameterClass(0);
                if (type == String.class) {
                    if (!isCreator && !isVisible) continue;
                    creators.addStringCreator((AnnotatedWithParams)ctor);
                    continue;
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    if (!isCreator && !isVisible) continue;
                    creators.addIntCreator((AnnotatedWithParams)ctor);
                    continue;
                }
                if (type == Long.TYPE || type == Long.class) {
                    if (!isCreator && !isVisible) continue;
                    creators.addLongCreator((AnnotatedWithParams)ctor);
                    continue;
                }
                if (type == Double.TYPE || type == Double.class) {
                    if (!isCreator && !isVisible) continue;
                    creators.addDoubleCreator((AnnotatedWithParams)ctor);
                    continue;
                }
                if (!isCreator) continue;
                creators.addDelegatingCreator((AnnotatedWithParams)ctor);
                continue;
            }
            if (!isCreator && !isVisible) continue;
            boolean annotationFound = false;
            boolean notAnnotatedParamFound = false;
            CreatorProperty[] properties = new CreatorProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = ctor.getParameter(i);
                String name = param == null ? null : intr.findPropertyNameForParam(param);
                Object injectId = intr.findInjectableValueId((AnnotatedMember)param);
                boolean hasName = name != null && name.length() > 0;
                boolean hasInject = injectId != null;
                if (notAnnotatedParamFound && ((annotationFound |= !(notAnnotatedParamFound |= !hasName && !hasInject)) || isCreator)) {
                    throw new IllegalArgumentException("Argument #" + i + " of constructor " + ctor + " has no property name annotation; must have name when multiple-paramater constructor annotated as Creator");
                }
                if (notAnnotatedParamFound) continue;
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param, injectId);
            }
            if (!annotationFound) continue;
            creators.addPropertyCreator((AnnotatedWithParams)ctor, properties);
        }
    }

    protected void _addDeserializerFactoryMethods(DeserializationConfig config, BasicBeanDescription beanDesc, VisibilityChecker<?> vchecker, AnnotationIntrospector intr, CreatorCollector creators) throws JsonMappingException {
        for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
            int argCount = factory.getParameterCount();
            if (argCount < 1) continue;
            boolean isCreator = intr.hasCreatorAnnotation((Annotated)factory);
            if (argCount == 1) {
                AnnotatedParameter param = factory.getParameter(0);
                String name = intr.findPropertyNameForParam(param);
                Object injectId = intr.findInjectableValueId((AnnotatedMember)param);
                if (injectId == null && (name == null || name.length() == 0)) {
                    Class type = factory.getParameterClass(0);
                    if (type == String.class) {
                        if (!isCreator && !vchecker.isCreatorVisible((AnnotatedMember)factory)) continue;
                        creators.addStringCreator((AnnotatedWithParams)factory);
                        continue;
                    }
                    if (type == Integer.TYPE || type == Integer.class) {
                        if (!isCreator && !vchecker.isCreatorVisible((AnnotatedMember)factory)) continue;
                        creators.addIntCreator((AnnotatedWithParams)factory);
                        continue;
                    }
                    if (type == Long.TYPE || type == Long.class) {
                        if (!isCreator && !vchecker.isCreatorVisible((AnnotatedMember)factory)) continue;
                        creators.addLongCreator((AnnotatedWithParams)factory);
                        continue;
                    }
                    if (type == Double.TYPE || type == Double.class) {
                        if (!isCreator && !vchecker.isCreatorVisible((AnnotatedMember)factory)) continue;
                        creators.addDoubleCreator((AnnotatedWithParams)factory);
                        continue;
                    }
                    if (type == Boolean.TYPE || type == Boolean.class) {
                        if (!isCreator && !vchecker.isCreatorVisible((AnnotatedMember)factory)) continue;
                        creators.addBooleanCreator((AnnotatedWithParams)factory);
                        continue;
                    }
                    if (!intr.hasCreatorAnnotation((Annotated)factory)) continue;
                    creators.addDelegatingCreator((AnnotatedWithParams)factory);
                    continue;
                }
            } else if (!intr.hasCreatorAnnotation((Annotated)factory)) continue;
            CreatorProperty[] properties = new CreatorProperty[argCount];
            for (int i = 0; i < argCount; ++i) {
                AnnotatedParameter param = factory.getParameter(i);
                String name = intr.findPropertyNameForParam(param);
                Object injectableId = intr.findInjectableValueId((AnnotatedMember)param);
                if ((name == null || name.length() == 0) && injectableId == null) {
                    throw new IllegalArgumentException("Argument #" + i + " of factory method " + factory + " has no property name annotation; must have when multiple-paramater static method annotated as Creator");
                }
                properties[i] = this.constructCreatorProperty(config, beanDesc, name, i, param, injectableId);
            }
            creators.addPropertyCreator((AnnotatedWithParams)factory, properties);
        }
    }

    protected CreatorProperty constructCreatorProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, int index, AnnotatedParameter param, Object injectableValueId) throws JsonMappingException {
        BeanProperty.Std property;
        JavaType t0 = config.getTypeFactory().constructType(param.getParameterType(), beanDesc.bindingsForBeanType());
        JavaType type = this.resolveType(config, beanDesc, t0, (AnnotatedMember)param, (BeanProperty)(property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), (AnnotatedMember)param)));
        if (type != t0) {
            property = property.withType(type);
        }
        JsonDeserializer deser = this.findDeserializerFromAnnotation(config, (Annotated)param, (BeanProperty)property);
        TypeDeserializer typeDeser = (TypeDeserializer)(type = this.modifyTypeByAnnotation(config, (Annotated)param, type, name)).getTypeHandler();
        if (typeDeser == null) {
            typeDeser = this.findTypeDeserializer(config, type, (BeanProperty)property);
        }
        CreatorProperty prop = new CreatorProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), param, index, injectableValueId);
        if (deser != null) {
            prop = prop.withValueDeserializer(deser);
        }
        return prop;
    }

    protected void addBeanProps(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        List props = beanDesc.findProperties();
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        boolean ignoreAny = false;
        Boolean B = intr.findIgnoreUnknownProperties(beanDesc.getClassInfo());
        if (B != null) {
            ignoreAny = B;
            builder.setIgnoreUnknownProperties(ignoreAny);
        }
        HashSet ignored = ArrayBuilders.arrayToSet((Object[])intr.findPropertiesToIgnore(beanDesc.getClassInfo()));
        for (String propName : ignored) {
            builder.addIgnorable(propName);
        }
        Set ignored2 = beanDesc.getIgnoredPropertyNames();
        if (ignored2 != null) {
            for (String propName : ignored2) {
                builder.addIgnorable(propName);
            }
        }
        HashMap ignoredTypes = new HashMap();
        for (BeanPropertyDefinition property : props) {
            SettableBeanProperty prop;
            Class type;
            String name = property.getName();
            if (ignored.contains(name)) continue;
            if (property.hasConstructorParameter()) {
                builder.addCreatorProperty(property);
                continue;
            }
            if (property.hasSetter()) {
                AnnotatedMethod setter = property.getSetter();
                type = setter.getParameterClass(0);
                if (this.isIgnorableType(config, beanDesc, type, ignoredTypes)) {
                    builder.addIgnorable(name);
                    continue;
                }
                prop = this.constructSettableProperty(config, beanDesc, name, setter);
                if (prop == null) continue;
                builder.addProperty(prop);
                continue;
            }
            if (!property.hasField()) continue;
            AnnotatedField field = property.getField();
            type = field.getRawType();
            if (this.isIgnorableType(config, beanDesc, type, ignoredTypes)) {
                builder.addIgnorable(name);
                continue;
            }
            prop = this.constructSettableProperty(config, beanDesc, name, field);
            if (prop == null) continue;
            builder.addProperty(prop);
        }
        AnnotatedMethod anySetter = beanDesc.findAnySetter();
        if (anySetter != null) {
            builder.setAnySetter(this.constructAnySetter(config, beanDesc, anySetter));
        }
        if (config.isEnabled(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS)) {
            for (BeanPropertyDefinition property : props) {
                AnnotatedMethod getter;
                Class rt;
                String name;
                if (!property.hasGetter() || builder.hasProperty(name = property.getName()) || ignored.contains(name) || !Collection.class.isAssignableFrom(rt = (getter = property.getGetter()).getRawType()) && !Map.class.isAssignableFrom(rt) || ignored.contains(name) || builder.hasProperty(name)) continue;
                builder.addProperty(this.constructSetterlessProperty(config, beanDesc, name, getter));
            }
        }
    }

    protected void addReferenceProperties(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map refs = beanDesc.findBackReferenceProperties();
        if (refs != null) {
            for (Map.Entry en : refs.entrySet()) {
                String name = (String)en.getKey();
                AnnotatedMember m = (AnnotatedMember)en.getValue();
                if (m instanceof AnnotatedMethod) {
                    builder.addBackReferenceProperty(name, this.constructSettableProperty(config, beanDesc, m.getName(), (AnnotatedMethod)m));
                    continue;
                }
                builder.addBackReferenceProperty(name, this.constructSettableProperty(config, beanDesc, m.getName(), (AnnotatedField)m));
            }
        }
    }

    protected void addInjectables(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) throws JsonMappingException {
        Map raw = beanDesc.findInjectables();
        if (raw != null) {
            boolean fixAccess = config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
            for (Map.Entry entry : raw.entrySet()) {
                AnnotatedMember m = (AnnotatedMember)entry.getValue();
                if (fixAccess) {
                    m.fixAccess();
                }
                builder.addInjectable(m.getName(), beanDesc.resolveType(m.getGenericType()), beanDesc.getClassAnnotations(), m, entry.getKey());
            }
        }
    }

    protected SettableAnyProperty constructAnySetter(DeserializationConfig config, BasicBeanDescription beanDesc, AnnotatedMethod setter) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter.fixAccess();
        }
        JavaType type = beanDesc.bindingsForBeanType().resolveType(setter.getParameterType(1));
        BeanProperty.Std property = new BeanProperty.Std(setter.getName(), type, beanDesc.getClassAnnotations(), (AnnotatedMember)setter);
        type = this.resolveType(config, beanDesc, type, (AnnotatedMember)setter, (BeanProperty)property);
        JsonDeserializer deser = this.findDeserializerFromAnnotation(config, (Annotated)setter, (BeanProperty)property);
        if (deser != null) {
            return new SettableAnyProperty((BeanProperty)property, setter, type, deser);
        }
        type = this.modifyTypeByAnnotation(config, (Annotated)setter, type, property.getName());
        return new SettableAnyProperty((BeanProperty)property, setter, type, null);
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedMethod setter) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            setter.fixAccess();
        }
        if ((type = this.resolveType(config, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(setter.getParameterType(0)), (AnnotatedMember)setter, (BeanProperty)(property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), (AnnotatedMember)setter)))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer propDeser = this.findDeserializerFromAnnotation(config, (Annotated)setter, (BeanProperty)property);
        type = this.modifyTypeByAnnotation(config, (Annotated)setter, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.MethodProperty prop = new SettableBeanProperty.MethodProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), setter);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        if ((ref = config.getAnnotationIntrospector().findReferenceType((AnnotatedMember)setter)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSettableProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedField field) throws JsonMappingException {
        AnnotationIntrospector.ReferenceProperty ref;
        BeanProperty.Std property;
        JavaType t0;
        JavaType type;
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            field.fixAccess();
        }
        if ((type = this.resolveType(config, beanDesc, t0 = beanDesc.bindingsForBeanType().resolveType(field.getGenericType()), (AnnotatedMember)field, (BeanProperty)(property = new BeanProperty.Std(name, t0, beanDesc.getClassAnnotations(), (AnnotatedMember)field)))) != t0) {
            property = property.withType(type);
        }
        JsonDeserializer propDeser = this.findDeserializerFromAnnotation(config, (Annotated)field, (BeanProperty)property);
        type = this.modifyTypeByAnnotation(config, (Annotated)field, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.FieldProperty prop = new SettableBeanProperty.FieldProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), field);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        if ((ref = config.getAnnotationIntrospector().findReferenceType((AnnotatedMember)field)) != null && ref.isManagedReference()) {
            prop.setManagedReferenceName(ref.getName());
        }
        return prop;
    }

    protected SettableBeanProperty constructSetterlessProperty(DeserializationConfig config, BasicBeanDescription beanDesc, String name, AnnotatedMethod getter) throws JsonMappingException {
        if (config.isEnabled(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
            getter.fixAccess();
        }
        JavaType type = getter.getType(beanDesc.bindingsForBeanType());
        BeanProperty.Std property = new BeanProperty.Std(name, type, beanDesc.getClassAnnotations(), (AnnotatedMember)getter);
        JsonDeserializer propDeser = this.findDeserializerFromAnnotation(config, (Annotated)getter, (BeanProperty)property);
        type = this.modifyTypeByAnnotation(config, (Annotated)getter, type, name);
        TypeDeserializer typeDeser = (TypeDeserializer)type.getTypeHandler();
        SettableBeanProperty.SetterlessProperty prop = new SettableBeanProperty.SetterlessProperty(name, type, typeDeser, beanDesc.getClassAnnotations(), getter);
        if (propDeser != null) {
            prop = prop.withValueDeserializer(propDeser);
        }
        return prop;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type, (boolean)true);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    protected boolean isIgnorableType(DeserializationConfig config, BasicBeanDescription beanDesc, Class<?> type, Map<Class<?>, Boolean> ignoredTypes) {
        Boolean status = ignoredTypes.get(type);
        if (status == null) {
            BasicBeanDescription desc = (BasicBeanDescription)config.introspectClassAnnotations(type);
            status = config.getAnnotationIntrospector().isIgnorableType(desc.getClassInfo());
            if (status == null) {
                status = Boolean.FALSE;
            }
        }
        return status;
    }

    static /* synthetic */ Deserializers[] access$000() {
        return NO_DESERIALIZERS;
    }
}

