/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.shiro.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final char DEFAULT_DELIMITER_CHAR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';

    public static boolean hasText(String str) {
        if (!StringUtils.hasLength((String)str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static String clean(String in) {
        String out = in;
        if (in != null && (out = in.trim()).equals("")) {
            out = null;
        }
        return out;
    }

    public static String toString(Object[] array) {
        return StringUtils.toDelimitedString((Object[])array, (String)",");
    }

    public static String toDelimitedString(Object[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String toDelimitedString(Collection c, String delimiter) {
        if (c == null || c.isEmpty()) {
            return "";
        }
        return StringUtils.join(c.iterator(), (String)delimiter);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray((String)str, (String)delimiters, (boolean)true, (boolean)true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] splitKeyValue(String aLine) throws ParseException {
        String line = StringUtils.clean((String)aLine);
        if (line == null) {
            return null;
        }
        String[] split = line.split(" ", 2);
        if (split.length != 2 && (split = line.split("=", 2)).length != 2) {
            String msg = "Unable to determine Key/Value pair from line [" + line + "].  There is no space from " + "which the split location could be determined.";
            throw new ParseException(msg, 0);
        }
        split[0] = StringUtils.clean((String)split[0]);
        split[1] = StringUtils.clean((String)split[1]);
        if (split[1].startsWith("=")) {
            split[1] = StringUtils.clean((String)split[1].substring(1));
        }
        if (split[0] == null) {
            String msg = "No valid key could be found in line [" + line + "] to form a key/value pair.";
            throw new ParseException(msg, 0);
        }
        if (split[1] == null) {
            String msg = "No corresponding value could be found in line [" + line + "] for key [" + split[0] + "]";
            throw new ParseException(msg, 0);
        }
        return split;
    }

    public static String[] split(String line) {
        return StringUtils.split((String)line, (char)',');
    }

    public static String[] split(String line, char delimiter) {
        return StringUtils.split((String)line, (char)delimiter, (char)'\"');
    }

    public static String[] split(String line, char delimiter, char quoteChar) {
        return StringUtils.split((String)line, (char)delimiter, (char)quoteChar, (char)quoteChar);
    }

    public static String[] split(String line, char delimiter, char beginQuoteChar, char endQuoteChar) {
        return StringUtils.split((String)line, (char)delimiter, (char)beginQuoteChar, (char)endQuoteChar, (boolean)false, (boolean)true);
    }

    public static String[] split(String aLine, char delimiter, char beginQuoteChar, char endQuoteChar, boolean retainQuotes, boolean trimTokens) {
        String line = StringUtils.clean((String)aLine);
        if (line == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == beginQuoteChar) {
                if (inQuotes && line.length() > i + 1 && line.charAt(i + 1) == beginQuoteChar) {
                    sb.append(line.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl = inQuotes = !inQuotes;
                if (!retainQuotes) continue;
                sb.append(c);
                continue;
            }
            if (c == endQuoteChar) {
                boolean bl = inQuotes = !inQuotes;
                if (!retainQuotes) continue;
                sb.append(c);
                continue;
            }
            if (c == delimiter && !inQuotes) {
                String s = sb.toString();
                if (trimTokens) {
                    s = s.trim();
                }
                tokens.add(s);
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        String s = sb.toString();
        if (trimTokens) {
            s = s.trim();
        }
        tokens.add(s);
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String join(Iterator<?> iterator, String separator) {
        String empty = "";
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? "" : first.toString();
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static Set<String> splitToSet(String delimited, String separator) {
        if (delimited == null || separator == null) {
            return null;
        }
        Object[] split = StringUtils.split((String)delimited, (char)separator.charAt(0));
        return CollectionUtils.asSet((Object[])split);
    }

    public static String uppercaseFirstChar(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        int length = in.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(Character.toUpperCase(in.charAt(0)));
        if (length > 1) {
            String remaining = in.substring(1);
            sb.append(remaining);
        }
        return sb.toString();
    }
}

