/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import org.apache.shiro.util.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFactory<T>
implements Factory<T> {
    private boolean singleton = true;
    private T singletonInstance;

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public T getInstance() {
        Object instance;
        if (this.isSingleton()) {
            if (this.singletonInstance == null) {
                this.singletonInstance = this.createInstance();
            }
            instance = this.singletonInstance;
        } else {
            instance = this.createInstance();
        }
        if (instance == null) {
            String msg = "Factory 'createInstance' implementation returned a null object.";
            throw new IllegalStateException(msg);
        }
        return (T)instance;
    }

    protected abstract T createInstance();
}

