/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.aop.AnnotationHandler;
import org.apache.shiro.aop.AnnotationResolver;
import org.apache.shiro.aop.DefaultAnnotationResolver;
import org.apache.shiro.aop.MethodInterceptorSupport;
import org.apache.shiro.aop.MethodInvocation;

public abstract class AnnotationMethodInterceptor
extends MethodInterceptorSupport {
    private AnnotationHandler handler;
    private AnnotationResolver resolver;

    public AnnotationMethodInterceptor(AnnotationHandler handler) {
        this(handler, (AnnotationResolver)new DefaultAnnotationResolver());
    }

    public AnnotationMethodInterceptor(AnnotationHandler handler, AnnotationResolver resolver) {
        if (handler == null) {
            throw new IllegalArgumentException("AnnotationHandler argument cannot be null.");
        }
        this.setHandler(handler);
        this.setResolver((AnnotationResolver)(resolver != null ? resolver : new DefaultAnnotationResolver()));
    }

    public AnnotationHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AnnotationHandler handler) {
        this.handler = handler;
    }

    public AnnotationResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(AnnotationResolver resolver) {
        this.resolver = resolver;
    }

    public boolean supports(MethodInvocation mi) {
        return this.getAnnotation(mi) != null;
    }

    protected Annotation getAnnotation(MethodInvocation mi) {
        return this.getResolver().getAnnotation(mi, this.getHandler().getAnnotationClass());
    }
}

