/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RegisterableObjectManager;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheObjectManager
extends RegisterableObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheObjectManager.class);
    private final Set<String> droppedPinningCaches = new CopyOnWriteArraySet<String>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void replayPut(ByteBuffer id, ByteBuffer key, ByteBuffer value, long lsn) {
        ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> stripe = this.getStripeFor(id);
        if (stripe != null) {
            stripe.replayPut(key, value, lsn);
            return;
        }
        if (EhcacheRestartability.isPinningIdentifier(id)) {
            String cache = EhcacheRestartability.getCacheNameFor(id);
            if (!this.droppedPinningCaches.add(cache)) return;
            LOGGER.info("Dropping pinning data for {} (likely due to a cache configuration change)", (Object)cache);
            return;
        }
        if (EhcacheRestartability.isCacheIdentifier(id)) {
            throw new CacheException("Unexpected data for cache " + EhcacheRestartability.getCacheNameFor(id) + " (this may be due to a corrupted metadata log)");
        }
        if (EhcacheRestartability.isWriteBehindIdentifier(id)) {
            throw new CacheException("Unexpected data for write-behind queue " + EhcacheRestartability.getCacheNameFor(id));
        }
        if (!EhcacheRestartability.isSoftLockIdentifier(id)) throw new IllegalStateException("Unexpected identifier : " + id.asCharBuffer().toString());
        throw new CacheException("Unexpected soft-lock data for cache " + EhcacheRestartability.getCacheNameFor(id));
    }
}

