/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.frs.TransactionException;
import java.io.File;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.writer.CacheWriterManager;

public class RestartableOffHeapDiskStore
extends OffHeapDiskStore {
    private final EhcacheRestartability ehcacheRestartability;
    private final boolean synchronous;

    public RestartableOffHeapDiskStore(File dataFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService, Pool<PoolableStore> onDiskPool, Ehcache cache, EhcacheRestartability ehcacheRestartability, boolean synchronous) {
        super(dataFile, map, eventService, onDiskPool, cache);
        this.ehcacheRestartability = ehcacheRestartability;
        this.synchronous = synchronous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        this.ehcacheRestartability.beginCacheStoreTransaction(this.synchronous);
        try {
            boolean bl = super.putWithWriter(element, writerManager);
            return bl;
        }
        finally {
            try {
                this.ehcacheRestartability.commitCacheStoreTransaction();
            }
            catch (TransactionException e) {
                throw new CacheException(e);
            }
        }
    }

    @Override
    public void dispose() {
    }
}

