/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.sampled.CacheSampler;
import net.sf.ehcache.management.sampled.ComprehensiveCacheSampler;
import net.sf.ehcache.management.service.AccessorPrefix;
import net.sf.ehcache.management.service.impl.ConstrainableEntityBuilderSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CacheEntityBuilder
extends ConstrainableEntityBuilderSupport<CacheSampler> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEntityBuilder.class);
    private static final String C_NAME_ACCESSOR = AccessorPrefix.get + "CacheName";
    private final Map<String, Set<ComprehensiveCacheSampler>> samplersByCMName = new HashMap();

    static CacheEntityBuilder createWith(ComprehensiveCacheSampler sampler, String cacheManagerName) {
        return new CacheEntityBuilder(sampler, cacheManagerName);
    }

    private CacheEntityBuilder(ComprehensiveCacheSampler sampler, String cacheManagerName) {
        this.addSampler(sampler, cacheManagerName);
    }

    CacheEntityBuilder add(ComprehensiveCacheSampler sampler, String cacheManagerName) {
        this.addSampler(sampler, cacheManagerName);
        return this;
    }

    CacheEntityBuilder add(Set<String> constraintAttributes) {
        this.addConstraints(constraintAttributes);
        return this;
    }

    Collection<CacheEntity> build() {
        ArrayList<CacheEntity> ces = new ArrayList<CacheEntity>(this.samplersByCMName.values().size());
        for (Map.Entry entry : this.samplersByCMName.entrySet()) {
            for (ComprehensiveCacheSampler sampler : (Set)entry.getValue()) {
                CacheEntity ce = new CacheEntity();
                ce.setCacheManagerName((String)entry.getKey());
                ce.setName(sampler.getCacheName());
                ce.setAgentId("embedded");
                if (this.getAttributeConstraints() != null && !this.getAttributeConstraints().isEmpty() && this.getAttributeConstraints().size() < CacheSampler.class.getMethods().length) {
                    this.buildAttributeMapByAttribute(CacheSampler.class, (Object)sampler, ce.getAttributes(), (Collection)this.getAttributeConstraints(), C_NAME_ACCESSOR);
                } else {
                    this.buildAttributeMapByApi(CacheSampler.class, (Object)sampler, ce.getAttributes(), (Collection)this.getAttributeConstraints(), C_NAME_ACCESSOR);
                }
                ces.add(ce);
            }
        }
        return ces;
    }

    Logger getLog() {
        return LOG;
    }

    private void addSampler(ComprehensiveCacheSampler sampler, String cacheManagerName) {
        if (sampler == null) {
            throw new IllegalArgumentException("sampler == null");
        }
        if (cacheManagerName == null) {
            throw new IllegalArgumentException("cacheManagerName == null");
        }
        HashSet<ComprehensiveCacheSampler> samplers = (HashSet<ComprehensiveCacheSampler>)this.samplersByCMName.get(cacheManagerName);
        if (samplers == null) {
            samplers = new HashSet<ComprehensiveCacheSampler>();
            this.samplersByCMName.put(cacheManagerName, samplers);
        }
        samplers.add(sampler);
    }
}

