/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services.validator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.terracotta.management.resource.services.Utils;
import org.terracotta.management.resource.services.validator.RequestValidator;

public abstract class AbstractEhcacheRequestValidator
implements RequestValidator {
    public abstract void validateSafe(UriInfo var1);

    public void validate(UriInfo info) {
        this.validateCacheRequestSegment(info.getPathSegments());
    }

    protected void validateCacheRequestSegment(List<PathSegment> pathSegments) {
        if (pathSegments.size() >= 3) {
            HashSet<String> cNames;
            String cacheNames = (String)pathSegments.get(2).getMatrixParameters().getFirst((Object)"names");
            HashSet<String> hashSet = cNames = Utils.trimToNull((String)cacheNames) == null ? null : new HashSet<String>(Arrays.asList(cacheNames.split(",")));
            if (cNames == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No cache specified. Unsafe requests must specify a single cache manager name.").build());
            }
            if (cNames.size() != 1) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Multiple caches specified. Unsafe requests must specify a single cache manager name.").build());
            }
        }
        this.validateCacheManagerRequestSegment(pathSegments);
    }

    protected void validateCacheManagerRequestSegment(List<PathSegment> pathSegments) {
        if (pathSegments.size() >= 2) {
            HashSet<String> cmNames;
            String cacheManagerNames = (String)pathSegments.get(1).getMatrixParameters().getFirst((Object)"names");
            HashSet<String> hashSet = cmNames = Utils.trimToNull((String)cacheManagerNames) == null ? null : new HashSet<String>(Arrays.asList(cacheManagerNames.split(",")));
            if (cmNames == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No cache manager specified. Unsafe requests must specify a single cache manager name.").build());
            }
            if (cmNames.size() != 1) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Multiple cache managers specified. Unsafe requests must specify a single cache manager name.").build());
            }
        }
        this.validateAgentSegment(pathSegments);
    }

    protected abstract void validateAgentSegment(List<PathSegment> var1);
}

