/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import com.terracotta.management.security.IdentityAssertionServiceClient;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.SSLContextFactory;
import com.terracotta.management.security.impl.DfltSSLContextFactory;
import com.terracotta.management.security.impl.JerseyIdentityAssertionServiceClient;
import com.terracotta.management.security.impl.ObfuscatedSecretFileStoreKeyChainAccessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.servlet.Filter;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.AbstractManagementServer;
import net.sf.ehcache.management.resource.services.validator.impl.EmbeddedEhcacheRequestValidator;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryService;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.embedded.FilterDetail;
import org.terracotta.management.embedded.StandaloneServer;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.LicenseServiceImpl;
import org.terracotta.management.resource.services.Utils;
import org.terracotta.management.resource.services.validator.RequestValidator;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ManagementServerImpl
extends AbstractManagementServer {
    public ManagementServerImpl(ManagementRESTServiceConfiguration configuration) {
        String basePackage = "net.sf.ehcache.management";
        String host = configuration.getHost();
        int port = configuration.getPort();
        List<EnvironmentLoaderListener> servletListeners = null;
        List<FilterDetail> filterDetails = null;
        if (Utils.trimToNull((String)configuration.getSecurityServiceLocation()) != null) {
            EnvironmentLoaderListener securityListener = new EnvironmentLoaderListener();
            servletListeners = Collections.singletonList(securityListener);
            ShiroFilter shiroSecurityFilter = new ShiroFilter();
            FilterDetail fd = new FilterDetail((Filter)shiroSecurityFilter, "/*");
            filterDetails = Collections.singletonList(fd);
        }
        this.loadEmbeddedAgentServiceLocator(configuration);
        SSLContext sslContext = null;
        boolean needClientAuth = false;
        if (configuration.isSslEnabled()) {
            sslContext = this.createSslContext();
            needClientAuth = configuration.isNeedClientAuth();
        }
        this.samplerRepoSvc = (SamplerRepositoryService)ServiceLocator.locate(SamplerRepositoryService.class);
        this.standaloneServer = new StandaloneServer(filterDetails, servletListeners, basePackage, host, port, sslContext, needClientAuth);
    }

    private void loadEmbeddedAgentServiceLocator(ManagementRESTServiceConfiguration configuration) {
        JerseyIdentityAssertionServiceClient idAssertionSvcClient;
        DfltSamplerRepositoryService samplerRepoSvc = new DfltSamplerRepositoryService();
        EmbeddedEhcacheRequestValidator reqValidator = new EmbeddedEhcacheRequestValidator();
        LicenseServiceImpl licenseService = new LicenseServiceImpl(true);
        ServiceLocator locator = new ServiceLocator();
        locator.loadService(LicenseService.class, (Object)licenseService).loadService(RequestValidator.class, (Object)reqValidator).loadService(CacheManagerService.class, (Object)samplerRepoSvc).loadService(CacheService.class, (Object)samplerRepoSvc).loadService(EntityResourceFactory.class, (Object)samplerRepoSvc).loadService(SamplerRepositoryService.class, (Object)samplerRepoSvc).loadService(ManagementRESTServiceConfiguration.class, (Object)configuration);
        ObfuscatedSecretFileStoreKeyChainAccessor kcAccessor = null;
        if (Utils.trimToNull((String)configuration.getSecurityServiceLocation()) != null || configuration.isSslEnabled()) {
            try {
                kcAccessor = new ObfuscatedSecretFileStoreKeyChainAccessor();
            }
            catch (KeychainInitializationException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid keyChain configuration.", e);
            }
            locator.loadService(KeyChainAccessor.class, (Object)kcAccessor);
        }
        DfltSSLContextFactory sslCtxtFactory = null;
        if (configuration.isSslEnabled()) {
            sslCtxtFactory = new DfltSSLContextFactory((KeyChainAccessor)kcAccessor, ManagementServerImpl.replaceBackslashesWithSlashes((String)System.getProperty("user.home")) + "/.tc/mgmt/keystore", ManagementServerImpl.replaceBackslashesWithSlashes((String)System.getProperty("user.home")) + "/.tc/mgmt/truststore", configuration.isNeedClientAuth());
            try {
                idAssertionSvcClient = new JerseyIdentityAssertionServiceClient((KeyChainAccessor)kcAccessor, (SSLContextFactory)sslCtxtFactory, configuration.getSecurityServiceLocation(), Integer.valueOf(configuration.getSecurityServiceTimeout()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid securityServiceLocation.", e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid securityServiceLocation.", e);
            }
            locator.loadService(IdentityAssertionServiceClient.class, (Object)idAssertionSvcClient);
            locator.loadService(KeyChainAccessor.class, (Object)kcAccessor);
            locator.loadService(SSLContextFactory.class, (Object)sslCtxtFactory);
        }
        if (Utils.trimToNull((String)configuration.getSecurityServiceLocation()) != null) {
            try {
                idAssertionSvcClient = new JerseyIdentityAssertionServiceClient((KeyChainAccessor)kcAccessor, sslCtxtFactory, configuration.getSecurityServiceLocation(), Integer.valueOf(configuration.getSecurityServiceTimeout()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid securityServiceLocation.", e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failure instantiating ManagementServer due to invalid securityServiceLocation.", e);
            }
            locator.loadService(IdentityAssertionServiceClient.class, (Object)idAssertionSvcClient);
        }
        ServiceLocator.load((ServiceLocator)locator);
    }

    private SSLContext createSslContext() {
        SSLContextFactory sslCtxtFactory = (SSLContextFactory)ServiceLocator.locate(SSLContextFactory.class);
        try {
            return sslCtxtFactory.create();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid KeyManagerFactory algorithm.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to inability to load keyStore.", e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid KeyStore type.", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to invalid certificates in a KeyStore.", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to bad key in a KeyStore.", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to one or more invalid keys in a KeyStore.", e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failure instantiating ManagementServer due to bad store location.", e);
        }
    }

    static String replaceBackslashesWithSlashes(String userHomeOnWindows) {
        return userHomeOnWindows.replace("\\", "/");
    }
}

