/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Average;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FloatAverage
extends Average {
    private float sum = 0.0f;
    private int count = 0;

    public FloatAverage(String attributeName, ValueType type) {
        super(attributeName, type);
    }

    @Override
    public void accept(Object input) throws IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (!(input instanceof Number)) {
            throw new IllegalArgumentException(input.getClass().getName() + " is not a number for attribute [" + this.getAttributeName() + "]");
        }
        ++this.count;
        this.sum += ((Number)input).floatValue();
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (incoming instanceof FloatAverage) {
            this.count += ((FloatAverage)incoming).count;
            this.sum += ((FloatAverage)incoming).sum;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Float getResult() {
        if (this.count == 0) {
            return null;
        }
        return Float.valueOf(this.sum / (float)this.count);
    }

    @Override
    Aggregator deserializeData(DataInput input) throws IOException {
        this.sum = input.readFloat();
        this.count = input.readInt();
        return this;
    }

    @Override
    void serializeData(DataOutput output) throws IOException {
        output.writeFloat(this.sum);
        output.writeInt(this.count);
    }
}

