/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.AggregatorOperations;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.SortOperations;
import com.terracottatech.search.StackOperations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SearchBuilder {
    private final List queryStack = new ArrayList();
    private final List<NVPair> aggregatorList = new ArrayList<NVPair>();
    private final Set<String> attributes = new HashSet<String>();
    private final Set<String> groupByAttrs = new HashSet<String>();
    private final List<NVPair> sortAttributes = new ArrayList<NVPair>();
    private boolean includeKeys = false;
    private boolean includeValues = false;
    private int maxResults = -1;

    public SearchBuilder includeKeys(boolean include) {
        this.includeKeys = include;
        return this;
    }

    public SearchBuilder includeValues(boolean include) {
        this.includeValues = include;
        return this;
    }

    public SearchBuilder attributeAscending(String attributeName) {
        this.sortAttributes.add(AbstractNVPair.createNVPair(attributeName, (Object)SortOperations.ASCENDING));
        return this;
    }

    public SearchBuilder attributeDescending(String attributeName) {
        this.sortAttributes.add(AbstractNVPair.createNVPair(attributeName, (Object)SortOperations.DESCENDING));
        return this;
    }

    public SearchBuilder groupBy(String attributeName) {
        this.groupByAttrs.add(attributeName);
        return this;
    }

    public SearchBuilder attribute(String attributeName) {
        this.attributes.add(attributeName);
        return this;
    }

    public SearchBuilder all() {
        this.add((Object)StackOperations.ALL);
        return this;
    }

    public SearchBuilder and() {
        this.add((Object)StackOperations.AND);
        return this;
    }

    public SearchBuilder or() {
        this.add((Object)StackOperations.OR);
        return this;
    }

    public SearchBuilder beginGroup() {
        this.add((Object)StackOperations.BEGIN_GROUP);
        return this;
    }

    public SearchBuilder endGroup() {
        this.add((Object)StackOperations.END_GROUP);
        return this;
    }

    public SearchBuilder ilike(String name, Object value) {
        this.add((Object)StackOperations.ILIKE);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder notIlike(String name, String regex) {
        this.add((Object)StackOperations.NOT_ILIKE);
        this.add(AbstractNVPair.createNVPair(name, regex));
        return this;
    }

    public SearchBuilder greaterThan(String name, Object value) {
        this.add((Object)StackOperations.GREATER_THAN);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder greaterThanEqual(String name, Object value) {
        this.add((Object)StackOperations.GREATER_THAN_EQUAL);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder lessThan(String name, Object value) {
        this.add((Object)StackOperations.LESS_THAN);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder lessThanEqual(String name, Object value) {
        this.add((Object)StackOperations.LESS_THAN_EQUAL);
        this.add(AbstractNVPair.createNVPair(name, value));
        return this;
    }

    public SearchBuilder between(String name1, Object value1, String name2, Object value2, boolean minInclusive, boolean maxInclusive) {
        this.add((Object)StackOperations.BETWEEN);
        this.add(AbstractNVPair.createNVPair(name1, value1));
        this.add(AbstractNVPair.createNVPair(name2, value2));
        this.add(AbstractNVPair.createNVPair("MIN_INCLUSIVE", minInclusive));
        this.add(AbstractNVPair.createNVPair("MAX_INCLUSIVE", maxInclusive));
        return this;
    }

    public SearchBuilder term(String attributeName, Object value) {
        this.add((Object)StackOperations.TERM);
        this.add(AbstractNVPair.createNVPair(attributeName, value));
        return this;
    }

    public SearchBuilder notEqualTerm(String attributeName, Object value) {
        this.add((Object)StackOperations.NOT_TERM);
        this.add(AbstractNVPair.createNVPair(attributeName, value));
        return this;
    }

    public SearchBuilder count() {
        this.aggregatorList.add(AbstractNVPair.createNVPair("COUNT", (Object)AggregatorOperations.COUNT));
        return this;
    }

    public SearchBuilder sum(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.SUM));
        return this;
    }

    public SearchBuilder average(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.AVERAGE));
        return this;
    }

    public SearchBuilder max(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.MAX));
        return this;
    }

    public SearchBuilder min(String attributeName) {
        this.aggregatorList.add(AbstractNVPair.createNVPair(attributeName, (Object)AggregatorOperations.MIN));
        return this;
    }

    public SearchBuilder maxResults(int max) {
        this.maxResults = max;
        return this;
    }

    private void add(Object obj) {
        this.queryStack.add(obj);
    }

    public Search build() {
        return new Search(this.includeKeys, this.includeValues, this.queryStack, this.attributes, this.groupByAttrs, this.aggregatorList, this.sortAttributes, this.maxResults);
    }

    public static class Search {
        private final boolean includeKeys;
        private final boolean includeValues;
        private final List queryStack;
        private final Set<String> attributes;
        private final Set<String> groupByAttrs;
        private final List<NVPair> aggregatorList;
        private final List<NVPair> sortAttributes;
        private final int maxResults;

        public Search(boolean includeKeys, boolean includeValues, List queryStack, Set<String> attributes, Set<String> groupByAttrs, List<NVPair> aggregatorList, List<NVPair> sortAttributes, int maxResults) {
            this.includeKeys = includeKeys;
            this.includeValues = includeValues;
            this.queryStack = queryStack;
            this.attributes = attributes;
            this.groupByAttrs = groupByAttrs;
            this.aggregatorList = aggregatorList;
            this.sortAttributes = sortAttributes;
            this.maxResults = maxResults;
        }

        public boolean isIncludeKeys() {
            return this.includeKeys;
        }

        public boolean isIncludeValues() {
            return this.includeValues;
        }

        public List getQueryStack() {
            return this.queryStack;
        }

        public Set<String> getAttributes() {
            return this.attributes;
        }

        public Set<String> getGroupByAttrs() {
            return this.groupByAttrs;
        }

        public List<NVPair> getAggregatorList() {
            return this.aggregatorList;
        }

        public List<NVPair> getSortAttributes() {
            return this.sortAttributes;
        }

        public int getMaxResults() {
            return this.maxResults;
        }
    }
}

