/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning.concurrent;

import com.terracottatech.offheapstore.eviction.EvictionListener;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.EvictionListeningWriteLockedPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.pinning.WriteLockedPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.util.Factory;

public class WriteLockedPinnableOffHeapClockCacheFactory<K, V>
implements Factory<WriteLockedPinnableOffHeapClockCache<K, V>> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private final EvictionListener<K, V> evictionListener;

    public WriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public WriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, EvictionListener<K, V> evictionListener) {
        this(tableSource, storageEngineFactory, evictionListener, 128);
    }

    public WriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, int tableSize) {
        this(tableSource, storageEngineFactory, null, tableSize);
    }

    public WriteLockedPinnableOffHeapClockCacheFactory(PageSource tableSource, Factory<? extends PinnableStorageEngine<? super K, ? super V>> storageEngineFactory, EvictionListener<K, V> evictionListener, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
        this.evictionListener = evictionListener;
    }

    @Override
    public WriteLockedPinnableOffHeapClockCache<K, V> newInstance() {
        PinnableStorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.evictionListener == null) {
                return new WriteLockedPinnableOffHeapClockCache<K, V>(this.tableSource, storageEngine, this.tableSize);
            }
            return new EvictionListeningWriteLockedPinnableOffHeapClockCache<K, V>(this.evictionListener, this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

