/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.transaction;

import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;

class TransactionHandleImpl
implements TransactionHandle {
    private final long id;

    TransactionHandleImpl(long id) {
        this.id = id;
    }

    static TransactionHandleImpl withByteBuffers(ByteBuffer[] buffers) {
        return new TransactionHandleImpl(ByteBufferUtils.getLong(buffers));
    }

    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(this.id).flip();
        return buffer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionHandleImpl that = (TransactionHandleImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "TransactionHandleImpl{id=" + this.id + '}';
    }
}

