/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RestartableObject;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.frs.object.heap.HeapValueSortedMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RestartableMap<K, V, RI, RK, RV>
implements ConcurrentMap<K, V>,
RestartableObject<RI, RK, RV> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ObjectManagerStripe<RI, RK, RV> objectManagerStripe = new MapObjectManagerStripe();
    private final RestartStore<RI, RK, RV> restartability;
    private final RI identifier;
    private final Map<K, V> dataMap = new ConcurrentHashMap();
    private final HeapValueSortedMap<K, Long> lsnMap = new HeapValueSortedMap();
    private final boolean synchronousWrites;
    private long byteSize = 0L;
    private Set<K> keySet;
    private Set<Map.Entry<K, V>> entrySet;

    public RestartableMap(RI identifier, RestartStore<RI, RK, RV> restartability, boolean synchronousWrites) {
        this.identifier = identifier;
        this.restartability = restartability;
        this.synchronousWrites = synchronousWrites;
    }

    public RestartableMap(RI identifier, RestartStore<RI, RK, RV> restartability) {
        this(identifier, restartability, true);
    }

    @Override
    public RI getId() {
        return this.identifier;
    }

    @Override
    public ObjectManagerStripe<RI, RK, RV> getObjectManagerStripe() {
        return this.objectManagerStripe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
        l.lock();
        try {
            int n = this.dataMap.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.dataMap.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.dataMap.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
        l.lock();
        try {
            boolean bl = this.dataMap.containsValue(value);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        ReentrantReadWriteLock.ReadLock l = this.lock.readLock();
        l.lock();
        try {
            V v = this.dataMap.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            V old = this.dataMap.put(key, value);
            RK encodedKey = this.encodeKey(key);
            RV encodedValue = this.encodeValue(value);
            this.byteSize += this.keyByteSize(key, encodedKey) + this.valueByteSize(value, encodedValue);
            this.restartability.beginTransaction(this.synchronousWrites).put(this.identifier, encodedKey, encodedValue).commit();
            V v = old;
            return v;
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            V removed = this.dataMap.remove(key);
            if (removed != null) {
                RK encodedKey = this.encodeKey(key);
                this.byteSize -= this.keyByteSize(key, encodedKey) + this.valueByteSize(removed, this.encodeValue(removed));
                this.restartability.beginTransaction(this.synchronousWrites).remove(this.identifier, encodedKey).commit();
            }
            V v = removed;
            return v;
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            this.dataMap.clear();
            this.restartability.beginTransaction(this.synchronousWrites).delete(this.identifier).commit();
            this.byteSize = 0L;
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            V old = this.get(key);
            if (old == null) {
                this.put(key, value);
            }
            V v = old;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            if (value.equals(this.get(key))) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            if (oldValue.equals(this.get(key))) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        ReentrantReadWriteLock.WriteLock l = this.lock.writeLock();
        l.lock();
        try {
            V old = this.get(key);
            if (old != null) {
                this.put(key, value);
            }
            V v = old;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new LockedSet<K>(this.dataMap.keySet()));
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        return es != null ? es : (this.entrySet = new LockedSet<Map.Entry<K, V>>(this.dataMap.entrySet()));
    }

    protected void replayPut(K key, V value) {
        this.dataMap.put(key, value);
    }

    protected abstract RK encodeKey(K var1);

    protected abstract RV encodeValue(V var1);

    protected abstract K decodeKey(RK var1);

    protected abstract V decodeValue(RV var1);

    protected abstract long keyByteSize(K var1, RK var2);

    protected abstract long valueByteSize(V var1, RV var2);

    private final class MapObjectManagerStripe
    implements ObjectManagerStripe<RI, RK, RV>,
    ObjectManagerSegment<RI, RK, RV> {
        private MapObjectManagerStripe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLowestLsn() {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                Long l2 = (Long)RestartableMap.this.lsnMap.firstValue();
                return l2;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getLsn(RK key) {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                Long l2 = (Long)RestartableMap.this.lsnMap.get(RestartableMap.this.decodeKey(key));
                return l2;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(RK rKey, RV rValue, long lsn) {
            block4: {
                Object key = RestartableMap.this.decodeKey(rKey);
                ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
                l.lock();
                try {
                    if (RestartableMap.this.dataMap.containsKey(key)) {
                        RestartableMap.this.lsnMap.put(key, lsn);
                        break block4;
                    }
                    throw new AssertionError();
                }
                finally {
                    l.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(RK rKey) {
            Object key = RestartableMap.this.decodeKey(rKey);
            ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
            l.lock();
            try {
                if (RestartableMap.this.dataMap.containsKey(key)) {
                    throw new AssertionError();
                }
                RestartableMap.this.lsnMap.remove(key);
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            block4: {
                ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
                l.lock();
                try {
                    if (RestartableMap.this.dataMap.isEmpty()) {
                        RestartableMap.this.lsnMap.clear();
                        break block4;
                    }
                    throw new AssertionError();
                }
                finally {
                    l.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replayPut(RK rKey, RV rValue, long lsn) {
            Object key = RestartableMap.this.decodeKey(rKey);
            Object value = RestartableMap.this.decodeValue(rValue);
            ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
            l.lock();
            try {
                if (RestartableMap.this.dataMap.containsKey(key)) {
                    throw new AssertionError();
                }
                RestartableMap.this.replayPut(key, value);
                RestartableMap.this.byteSize += RestartableMap.this.keyByteSize(key, rKey) + RestartableMap.this.valueByteSize(value, rValue);
                RestartableMap.this.lsnMap.put(key, lsn);
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public Collection<ObjectManagerSegment<RI, RK, RV>> getSegments() {
            return Collections.singleton(this);
        }

        @Override
        public void updateLsn(ObjectManagerEntry<RI, RK, RV> entry, long newLsn) {
            Object key = RestartableMap.this.decodeKey(entry.getKey());
            if (entry.getLsn() != ((Long)RestartableMap.this.lsnMap.get(key)).longValue()) {
                throw new AssertionError();
            }
            RestartableMap.this.lsnMap.put(key, newLsn);
        }

        @Override
        public ObjectManagerEntry<RI, RK, RV> acquireCompactionEntry(long ceilingLsn) {
            ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
            l.lock();
            try {
                Object key = RestartableMap.this.lsnMap.firstKey();
                if (key == null) {
                    l.unlock();
                    return null;
                }
                long lsn = (Long)RestartableMap.this.lsnMap.firstValue();
                if (lsn >= ceilingLsn) {
                    l.unlock();
                    return null;
                }
                Object rKey = RestartableMap.this.encodeKey(key);
                Object rValue = RestartableMap.this.encodeValue(RestartableMap.this.dataMap.get(key));
                return new SimpleObjectManagerEntry(RestartableMap.this.identifier, rKey, rValue, lsn);
            }
            catch (RuntimeException e) {
                l.unlock();
                throw e;
            }
            catch (Error e) {
                l.unlock();
                throw e;
            }
        }

        @Override
        public void releaseCompactionEntry(ObjectManagerEntry<RI, RK, RV> entry) {
            if (entry == null) {
                throw new NullPointerException("Tried to release a null entry.");
            }
            RestartableMap.this.lock.writeLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long size() {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                long l2 = RestartableMap.this.lsnMap.size();
                return l2;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long sizeInBytes() {
            ReentrantReadWriteLock.WriteLock l = RestartableMap.this.lock.writeLock();
            l.lock();
            try {
                long l2 = RestartableMap.this.byteSize;
                return l2;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public void updateLsn(int hash, ObjectManagerEntry<RI, RK, RV> entry, long newLsn) {
            this.updateLsn(entry, newLsn);
        }

        @Override
        public Long getLsn(int hash, RK key) {
            return this.getLsn((RK)key);
        }

        @Override
        public void put(int hash, RK key, RV value, long lsn) {
            this.put((RK)key, (RV)value, lsn);
        }

        @Override
        public void replayPut(int hash, RK key, RV value, long lsn) {
            this.replayPut((RK)key, (RV)value, lsn);
        }

        @Override
        public void remove(int hash, RK key) {
            this.remove((RK)key);
        }
    }

    private final class LockedSet<T>
    extends AbstractSet<T> {
        private final Set<T> delegate;

        LockedSet(Set<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<T> iterator() {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                Iterator iterator = new Iterator<T>(){
                    private final Iterator<T> delegateIterator;
                    {
                        this.delegateIterator = LockedSet.this.delegate.iterator();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        ReentrantReadWriteLock.ReadLock lk = RestartableMap.this.lock.readLock();
                        lk.lock();
                        try {
                            boolean bl = this.delegateIterator.hasNext();
                            return bl;
                        }
                        finally {
                            lk.unlock();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T next() {
                        ReentrantReadWriteLock.ReadLock lk = RestartableMap.this.lock.readLock();
                        lk.lock();
                        try {
                            Object t = this.delegateIterator.next();
                            return t;
                        }
                        finally {
                            lk.unlock();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                return iterator;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                boolean bl = this.delegate.contains(o);
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            ReentrantReadWriteLock.ReadLock l = RestartableMap.this.lock.readLock();
            l.lock();
            try {
                int n = this.delegate.size();
                return n;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

