/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferBuilder;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.CachingBufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.ManualBufferSource;
import com.terracottatech.frs.io.Stream;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.NIOSegmentImpl;
import com.terracottatech.frs.io.nio.NIOSegmentList;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Exchanger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NIOStreamImpl
implements Stream {
    private static final String BAD_STREAM_ID = "mis-aligned streams";
    private final File directory;
    private final long segmentSize;
    private final NIOSegmentList segments;
    private UUID streamId;
    private volatile long lowestMarker = 99L;
    private volatile long lowestMarkerOnDisk = 0L;
    private long currentMarker = 99L;
    private NIOSegmentImpl writeHead;
    private NIOSegmentImpl readHead;
    private BufferSource manualPool;
    private FSyncer syncer;
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);
    private BufferBuilder createBuffer;
    private HashMap<String, Integer> strategies;

    public NIOStreamImpl(File filePath, long recommendedSize) throws IOException {
        this(filePath, recommendedSize, recommendedSize);
    }

    public NIOStreamImpl(File filePath, long recommendedSize, long memorySize) throws IOException {
        this.directory = filePath;
        if (LOGGER.isDebugEnabled()) {
            this.strategies = new HashMap();
        }
        this.segmentSize = recommendedSize;
        if (memorySize < this.segmentSize * 4L) {
            memorySize = this.segmentSize * 4L;
        }
        LOGGER.debug("==CONFIG(nio)==" + filePath.getAbsolutePath() + " using a segment size of " + this.segmentSize / 0x100000L);
        LOGGER.debug("==CONFIG(nio)==" + filePath.getAbsolutePath() + " using a memory size of " + memorySize / 0x100000L);
        this.manualPool = new ManualBufferSource(new CachingBufferSource(), memorySize);
        this.segments = new NIOSegmentList(this.directory);
        if (this.segments.isEmpty()) {
            this.streamId = UUID.randomUUID();
        } else {
            try {
                NIOSegmentImpl seg = new NIOSegmentImpl(this, this.segments.getBeginningFile());
                seg.openForHeader(this.manualPool);
                this.streamId = seg.getStreamId();
                seg.close();
            }
            catch (HeaderException header) {
                this.streamId = UUID.randomUUID();
            }
            catch (IOException ioe) {
                this.streamId = UUID.randomUUID();
            }
        }
    }

    public void setBufferBuilder(BufferBuilder builder) {
        this.createBuffer = builder;
    }

    BufferBuilder getBufferBuilder() {
        return this.createBuffer;
    }

    @Override
    public UUID getStreamId() {
        return this.streamId;
    }

    public void setMinimumMarker(long lowestMarker) {
        this.lowestMarker = lowestMarker;
    }

    public long getMarker() {
        return this.currentMarker;
    }

    public long getMinimumMarker() {
        return this.lowestMarker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkForCleanExit() throws IOException {
        if (this.segments.isEmpty()) {
            return true;
        }
        NIOSegmentImpl seg = new NIOSegmentImpl(this, this.segments.getEndFile());
        try {
            try {
                seg.openForHeader(this.manualPool);
            }
            catch (HeaderException header) {
                boolean bl = false;
                seg.close();
                return bl;
            }
            if (!seg.getStreamId().equals(this.streamId)) {
                throw new IOException(BAD_STREAM_ID);
            }
            boolean bl = seg.wasProperlyClosed();
            return bl;
        }
        finally {
            seg.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean open() throws IOException {
        if (this.segments.isEmpty()) {
            return false;
        }
        this.segments.setReadPosition(-1L);
        ListIterator files = this.segments.listIterator(this.segments.size());
        while (files.hasPrevious()) {
            File f = (File)files.previous();
            NIOSegmentImpl seg = new NIOSegmentImpl(this, f);
            try {
                seg.openForHeader(this.manualPool);
                if (!seg.getStreamId().equals(this.streamId)) {
                    throw new IOException(BAD_STREAM_ID);
                }
                if (seg.last()) {
                    this.currentMarker = seg.getMaximumMarker();
                    this.lowestMarkerOnDisk = this.lowestMarker = seg.getMinimumMarker();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (HeaderException h) {
            }
            finally {
                seg.close();
            }
            files.remove();
            if (!f.exists()) continue;
            throw new IOException("unable to make log stream consistent");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void limit(UUID streamId, int segment, long position) throws IOException {
        this.segments.setReadPosition(-1L);
        File f = this.segments.nextReadFile(Direction.REVERSE);
        while (f != null) {
            NIOSegmentImpl seg = new NIOSegmentImpl(this, f);
            try {
                seg.openForHeader(this.manualPool);
                if (!seg.getStreamId().equals(streamId)) {
                    throw new IOException(BAD_STREAM_ID);
                }
                if (seg.getSegmentId() == segment) {
                    this.segments.removeFilesFromHead();
                    if (!this.segments.currentIsHead()) {
                        throw new IOException("unable to make log stream consistent");
                    }
                    seg.limit(position);
                    return;
                }
            }
            catch (HeaderException ioe) {
            }
            finally {
                seg.close();
            }
            f = this.segments.nextReadFile(Direction.REVERSE);
        }
    }

    private boolean doubleCheck(File f) throws IOException {
        NIOSegmentImpl segment = new NIOSegmentImpl(this, f);
        try {
            segment.openForHeader(this.manualPool);
        }
        catch (HeaderException header) {
            throw new IOException(header);
        }
        if (segment.getBaseMarker() > this.lowestMarkerOnDisk) {
            return false;
        }
        if (!segment.last()) {
            return false;
        }
        return segment.getMaximumMarker() > this.lowestMarkerOnDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findLogTail() throws IOException {
        this.segments.setReadPosition(0L);
        File f = this.segments.nextReadFile(Direction.FORWARD);
        long size = 0L;
        while (f != null) {
            NIOSegmentImpl seg = new NIOSegmentImpl(this, f);
            try {
                try {
                    seg.openForHeader(this.manualPool);
                }
                catch (HeaderException header) {
                    throw new IOException(header);
                }
                if (!seg.getStreamId().equals(this.streamId)) {
                    throw new IOException(BAD_STREAM_ID);
                }
                if (seg.getBaseMarker() > this.lowestMarkerOnDisk) {
                    File last = this.segments.nextReadFile(Direction.REVERSE);
                    size = last != null ? (size -= last.length()) : 0L;
                    long l = size;
                    return l;
                }
                if (f.equals(this.segments.getEndFile())) {
                    long l = size;
                    return l;
                }
                size += seg.length();
            }
            finally {
                seg.close();
            }
            f = this.segments.nextReadFile(Direction.FORWARD);
        }
        return size;
    }

    long trimLogTail(long timeout) throws IOException {
        if (this.findLogTail() != 0L) {
            File last = this.segments.getCurrentReadFile();
            assert (last != null);
            if (this.doubleCheck(last)) {
                return this.segments.removeFilesFromTail();
            }
        }
        return 0L;
    }

    @Override
    public long append(Chunk c, long marker) throws IOException {
        if (this.writeHead == null || this.writeHead.isClosed()) {
            File f = this.segments.appendFile();
            this.writeHead = new NIOSegmentImpl(this, f).openForWriting(this.manualPool);
            this.writeHead.insertFileHeader(this.lowestMarker, this.currentMarker + 1L);
        }
        long w = this.writeHead.append(c, marker);
        this.currentMarker = marker;
        if (this.writeHead.length() > this.segmentSize) {
            this.writeHead.prepareForClose();
            if (this.syncer != null) {
                this.syncer.pivot(this.writeHead);
            } else {
                this.writeHead.close();
                this.lowestMarkerOnDisk = this.writeHead.getMinimumMarker();
            }
        }
        return w;
    }

    @Override
    public long sync() throws IOException {
        if (this.writeHead != null && !this.writeHead.isClosed()) {
            long pos = this.writeHead.position();
            if (this.syncer != null) {
                this.syncer.pivot(this.writeHead);
                NIOSegmentImpl check = this.syncer.pivot(null);
                assert (check == this.writeHead);
                return pos;
            }
            pos = this.writeHead.fsync();
            this.lowestMarkerOnDisk = this.writeHead.getMinimumMarker();
            return pos;
        }
        return -1L;
    }

    @Override
    public void close() throws IOException {
        if (this.writeHead != null && !this.writeHead.isClosed()) {
            try {
                this.writeHead.prepareForClose();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.writeHead.close();
        }
        this.writeHead = null;
        if (this.readHead != null && !this.readHead.isClosed()) {
            this.readHead.close();
        }
        this.readHead = null;
        if (this.syncer != null) {
            this.syncer.interrupt();
            try {
                this.syncer.join();
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("==PERFORMANCE(memory)==" + this.manualPool.toString());
            StringBuilder slist = new StringBuilder();
            for (Map.Entry<String, Integer> e : this.strategies.entrySet()) {
                slist.append(" ");
                slist.append(e.getKey());
                slist.append(":");
                slist.append(e.getValue());
            }
            LOGGER.debug("==PERFORMANCE(strategies)==" + slist.toString());
        }
        this.manualPool.reclaim();
    }

    @Override
    public Chunk read(Direction dir) throws IOException {
        while (this.readHead == null || !this.readHead.hasMore(dir)) {
            if (this.readHead != null) {
                this.readHead.close();
            }
            try {
                File f = this.segments.nextReadFile(dir);
                if (f == null) {
                    this.readHead = null;
                    return null;
                }
                NIOSegmentImpl nextHead = new NIOSegmentImpl(this, f).openForReading(this.manualPool);
                if (this.readHead != null) {
                    int expected = this.readHead.getSegmentId() + (dir == Direction.REVERSE ? -1 : 1);
                    if (nextHead.getSegmentId() != expected) {
                        throw new IOException("broken stream during readback");
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    String strat = nextHead.getStrategyDebug();
                    Integer count = this.strategies.get(strat);
                    if (count == null) {
                        this.strategies.put(strat, 1);
                    } else {
                        this.strategies.put(strat, count + 1);
                    }
                }
                this.readHead = nextHead;
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            this.checkStreamId(this.readHead);
        }
        return this.readHead.next(dir);
    }

    private void checkStreamId(NIOSegmentImpl segment) throws IOException {
        if (!this.streamId.equals(segment.getStreamId())) {
            throw new IOException(BAD_STREAM_ID);
        }
    }

    @Override
    public void seek(long loc) throws IOException {
        this.segments.setReadPosition(loc);
        if (this.readHead != null) {
            this.readHead.close();
        }
        this.readHead = null;
    }

    int getSegmentId() {
        return this.readHead.getSegmentId();
    }

    long getTotalSize() {
        return this.segments.getTotalSize();
    }

    int getSegmentCount() {
        return this.segments.getCount();
    }

    @Override
    public Iterator<Chunk> iterator() {
        return new Iterator<Chunk>(){
            Chunk next;

            @Override
            public boolean hasNext() {
                try {
                    if (this.next != null) {
                        return true;
                    }
                    this.next = NIOStreamImpl.this.read(Direction.getDefault());
                    return this.next != null;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public Chunk next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    class FSyncer
    extends Thread {
        private Exchanger<NIOSegmentImpl> pivot = new Exchanger();

        public FSyncer() {
            this.setName("fsync helper");
            this.setDaemon(true);
        }

        NIOSegmentImpl pivot(NIOSegmentImpl target) {
            try {
                return this.pivot.exchange(target);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }

        @Override
        public void run() {
            try {
                NIOSegmentImpl seg = null;
                seg = this.pivot.exchange(seg);
                while (!Thread.interrupted()) {
                    if (seg != null) {
                        if (seg.isClosed()) {
                            seg.close();
                        } else {
                            seg.fsync();
                        }
                    }
                    NIOStreamImpl.this.lowestMarkerOnDisk = seg.getMinimumMarker();
                    seg = this.pivot.exchange(seg);
                }
            }
            catch (InterruptedException ie) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

