/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.PutAction;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import java.nio.ByteBuffer;

class CompactionAction
extends PutAction {
    private final ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry;
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private Long lsn;

    CompactionAction(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry) {
        super(objectManager, null, entry.getId(), entry.getKey(), entry.getValue(), entry.getLsn());
        this.objectManager = objectManager;
        this.entry = entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(long lsn) {
        CompactionAction compactionAction = this;
        synchronized (compactionAction) {
            this.lsn = lsn;
            this.notifyAll();
        }
    }

    synchronized void updateObjectManager() {
        boolean interrupted = false;
        while (this.lsn == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.objectManager.updateLsn(this.entry, this.lsn);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void replay(long lsn) {
        throw new UnsupportedOperationException("Compaction actions can't be replayed.");
    }
}

