/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.user.impl;

import com.terracotta.management.security.PasswordHashService;
import com.terracotta.management.security.shiro.Shiro1FormattingHashService;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.impl.DfltUserInfo;
import java.util.Arrays;
import java.util.HashSet;

public final class DfltUserInfoFactory
implements UserInfoFactory {
    private final PasswordHashService pwdHashSvc;

    public DfltUserInfoFactory() {
        this((PasswordHashService)new Shiro1FormattingHashService());
    }

    public DfltUserInfoFactory(PasswordHashService pwdHashSvc) {
        this.pwdHashSvc = pwdHashSvc;
    }

    public UserInfo createUser(String username, String password, UserRole ... roles) {
        HashSet<UserRole> roleSet = roles == null ? null : new HashSet<UserRole>(Arrays.asList(roles));
        String pwdHash = password == null ? null : this.pwdHashSvc.computeFormattedHash(password);
        return new DfltUserInfo(username, pwdHash, roleSet);
    }
}

