/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.keychain;

import com.terracotta.management.keychain.KeyName;
import java.net.URI;
import java.net.URISyntaxException;

public class URIKeyName
implements KeyName {
    private static final long serialVersionUID = 8278719757373245391L;
    private URI theURI;

    public URIKeyName(String uri) throws URISyntaxException {
        this.theURI = this.standardizeURI(new URI(uri));
    }

    public URIKeyName(URI uri) {
        this.theURI = this.standardizeURI(uri);
    }

    public String toString() {
        return this.theURI.toString();
    }

    private URI standardizeURI(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        if (scheme != null && (scheme.equals("http") || scheme.equals("https"))) {
            if (host.equals("127.0.0.1")) {
                host = "localhost";
            }
            if (path != null && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path == null || path.length() == 0) {
                path = "/";
            }
            if (port < 1) {
                port = scheme.equals("http") ? 80 : 443;
            }
            try {
                if (query == null || query.length() == 0) {
                    return new URI(scheme + "://" + host + ":" + port + path);
                }
                return new URI(scheme + "://" + host + ":" + port + path + "?" + query);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid URI unexpectedly generated!", e);
            }
        }
        return uri;
    }

    public URI getURI() {
        return this.theURI;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.theURI == null ? 0 : this.theURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URIKeyName other = (URIKeyName)obj;
        return !(this.theURI == null ? other.theURI != null : !this.theURI.equals(other.theURI));
    }
}

