/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.txw2;

import com.sun.xml.txw2.Content;
import com.sun.xml.txw2.ContentVisitor;
import com.sun.xml.txw2.DatatypeWriter;
import com.sun.xml.txw2.NamespaceDecl;
import com.sun.xml.txw2.NamespaceResolver;
import com.sun.xml.txw2.NamespaceSupport;
import com.sun.xml.txw2.StartDocument;
import com.sun.xml.txw2.output.XmlSerializer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Document {
    private final XmlSerializer out;
    private boolean started = false;
    private Content current = null;
    private final Map<Class, DatatypeWriter> datatypeWriters = new HashMap();
    private int iota = 1;
    private final NamespaceSupport inscopeNamespace = new NamespaceSupport();
    private NamespaceDecl activeNamespaces;
    private final ContentVisitor visitor = new /* Unavailable Anonymous Inner Class!! */;
    private final StringBuilder prefixSeed = new StringBuilder("ns");
    private int prefixIota = 0;
    static final char MAGIC = '\u0000';

    Document(XmlSerializer out) {
        this.out = out;
        for (DatatypeWriter dw : DatatypeWriter.BUILTIN) {
            this.datatypeWriters.put(dw.getType(), dw);
        }
    }

    void flush() {
        this.out.flush();
    }

    void setFirstContent(Content c) {
        assert (this.current == null);
        this.current = new StartDocument();
        this.current.setNext(this, c);
    }

    public void addDatatypeWriter(DatatypeWriter<?> dw) {
        this.datatypeWriters.put(dw.getType(), dw);
    }

    void run() {
        Content next;
        while ((next = this.current.getNext()) != null && next.isReadyToCommit()) {
            next.accept(this.visitor);
            next.written();
            this.current = next;
        }
        return;
    }

    void writeValue(Object obj, NamespaceResolver nsResolver, StringBuilder buf) {
        if (obj == null) {
            throw new IllegalArgumentException("argument contains null");
        }
        if (obj instanceof Object[]) {
            for (Object o : (Object[])obj) {
                this.writeValue(o, nsResolver, buf);
            }
            return;
        }
        if (obj instanceof Iterable) {
            for (Object o : (Iterable)obj) {
                this.writeValue(o, nsResolver, buf);
            }
            return;
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
            DatatypeWriter dw = (DatatypeWriter)this.datatypeWriters.get(c);
            if (dw == null) continue;
            dw.print(obj, nsResolver, buf);
            return;
        }
        buf.append(obj);
    }

    private String newPrefix() {
        this.prefixSeed.setLength(2);
        this.prefixSeed.append(++this.prefixIota);
        return this.prefixSeed.toString();
    }

    private StringBuilder fixPrefix(StringBuilder buf) {
        int i;
        assert (this.activeNamespaces != null);
        int len = buf.length();
        for (i = 0; i < len && buf.charAt(i) != '\u0000'; ++i) {
        }
        if (i == len) {
            return buf;
        }
        while (i < len) {
            char uriIdx = buf.charAt(i + 1);
            NamespaceDecl ns = this.activeNamespaces;
            while (ns != null && ns.uniqueId != uriIdx) {
                ns = ns.next;
            }
            if (ns == null) {
                throw new IllegalStateException("Unexpected use of prefixes " + buf);
            }
            int length = 2;
            String prefix = ns.prefix;
            if (prefix.length() == 0) {
                if (buf.length() <= i + 2 || buf.charAt(i + 2) != ':') {
                    throw new IllegalStateException("Unexpected use of prefixes " + buf);
                }
                length = 3;
            }
            buf.replace(i, i + length, prefix);
            len += prefix.length() - length;
            while (i < len && buf.charAt(i) != '\u0000') {
                ++i;
            }
        }
        return buf;
    }

    char assignNewId() {
        return (char)this.iota++;
    }

    static /* synthetic */ XmlSerializer access$000(Document x0) {
        return x0.out;
    }

    static /* synthetic */ NamespaceSupport access$100(Document x0) {
        return x0.inscopeNamespace;
    }

    static /* synthetic */ NamespaceDecl access$202(Document x0, NamespaceDecl x1) {
        x0.activeNamespaces = x1;
        return x0.activeNamespaces;
    }

    static /* synthetic */ NamespaceDecl access$200(Document x0) {
        return x0.activeNamespaces;
    }

    static /* synthetic */ StringBuilder access$300(Document x0, StringBuilder x1) {
        return x0.fixPrefix(x1);
    }

    static /* synthetic */ boolean access$400(Document x0) {
        return x0.started;
    }

    static /* synthetic */ boolean access$402(Document x0, boolean x1) {
        x0.started = x1;
        return x0.started;
    }

    static /* synthetic */ String access$500(Document x0) {
        return x0.newPrefix();
    }
}

